% Generated by roxygen2 (4.0.0): do not edit by hand
\name{source_XlsxData}
\alias{source_XlsxData}
\title{Download an Excel data set}
\usage{
source_XlsxData(url, sheet = NULL, sha1 = NULL, cache = FALSE,
  clearCache = FALSE, ...)
}
\arguments{
\item{url}{character string of the Excel files's URL.}

\item{sheet}{character string of number of representing the sheet in the
workbook to return. Only one sheet at a time can currently be returned}

\item{sha1}{Character string of the file's SHA-1 hash, generated by
\code{source_data}. Note if you are using data stored using Git, this is not
the file's commit SHA-1 hash.}

\item{cache}{logical. Whether or not to cache the data so that it is not
downloaded every time the function is called.}

\item{clearCache}{logical. Whether or not to clear the downloaded data from
the cache.}

\item{...}{arguments to pass to \code{\link{read.xlsx}}.}
}
\value{
a data frame
}
\description{
\code{source_XlsxData} loads Excel data stored at a URL (both http
and https) into R.
}
\seealso{
\code{\link{read.xlsx}}, \link{httr}, \code{\link{source_data}}
}

