% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{package_dependencies}
\alias{package_dependencies}
\title{Find current installations}
\usage{
package_dependencies(packages = ".", which = "strong")
}
\arguments{
\item{packages}{Path to a file with a DESCRIPTION file or package's names from a repository.}

\item{which}{a character vector listing the types of
    dependencies, a subset of
    \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
    Character string \code{"all"} is shorthand for that vector,
    character string \code{"most"} for the same vector without
    \code{"Enhances"},
    character string \code{"strong"} (default) for the first three
    elements of that vector.
  }
}
\value{
A data.frame with the name, version required, if only one package requires it it also show the name of the package.
\code{NA} if not able to collect the data from repositories.
}
\description{
Despite the description minimal requirements find which versions are
required due to dependencies.
}
\note{
It keeps the base packages too even if just knowing the R version required would be enough.
}
\examples{
pd <- package_dependencies("ggeasy")
head(pd)
}
