% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_dependencies}
\alias{repo_dependencies}
\title{Build and/or plots the repo's dependency graph}
\usage{
repo_dependencies(repo, depends = T, attached = T, generated = T,
  plot = T)
}
\arguments{
\item{repo}{An object of class repo.}

\item{depends}{If TRUE, show "depends" edges.}

\item{attached}{If TRUE, show "attached" edges.}

\item{generated}{If TRUE, show "generated" edges.}

\item{plot}{If TRUE (default), plot the dependency graph.}
}
\value{
Adjacency matrix representing the graph, with edges labeled
1, 2, 3 corresponding to "depends", "attached" and "generated" edge
types respectively.
}
\description{
Creates an weighted adjacency matrix, such that (i,j) = x means
that item i is in relation x with item j and possibly plots it.
}
\details{
The relation between any two items i,j can be 1, 2 or
3, respectively meaning:

- depends on: to build item i, item j was necessary

- is attached to: item i is an attachment item and is attached to
item j.

- has been generated by: item i has been generated by a resource
described by the string of characters j, which is typically the
file name of a script.
}
\examples{
## Repository creation (or opening, if exists)
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)

## Producing some irrelevant data
data1 <- 1:10
data2 <- data1 * 2
data3 <- data1 / 2

## Putting the data in the database, specifying dependencies
repo$put(data1, "item1", "First item", "repo_dependencies", replace=TRUE)
repo$put(data2, "item2", "Item dependent on item1",
    "repo_dependencies", depends="item1", replace=TRUE)
repo$put(data3, "item3", "Item dependent on item1 and item2",
    "repo_dependencies", depends=c("item1", "item2"), replace=TRUE)

## Obtaining the dependency matrix
depmat <- repo$dependencies(plot=FALSE)
## Simplifying labels
rownames(depmat) <- colnames(depmat) <- basename(rownames(depmat))
print(depmat)
## The matrix can also be plotted as a graph (requires igraph package)
## repo$dependencies(generated=F) # turning off "generated" edges

## wiping temporary repo
unlink(repo_path, TRUE)
}

