% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_info}
\alias{repo_info}
\title{Provides detailed information about an item.}
\usage{
repo_info(repo, name = NULL, tags = NULL)
}
\arguments{
\item{repo}{An object of class repo.}

\item{name}{Item name. If both name and tags are NULL, information
about the whole repo will be provided.}

\item{tags}{List of tags: info will run on all items matching the tag list.}
}
\value{
Used for side effects.
}
\description{
Provides detailed information about an item.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)
repo$put(1, "item1", "Sample item 1", "info", replace=TRUE)
repo$info("item1")

## wiping temporary repo
unlink(repo_path, TRUE)
}

