% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_attach}
\alias{repo_attach}
\title{Create a new item from an existing file.}
\usage{
repo_attach(filepath, description = NULL, tags = NULL, prj = NULL,
  src = NULL, chunk = basename(filepath), replace = F, to = NULL,
  URL = NULL)
}
\arguments{
\item{filepath}{The path to the file to be stored in the repo.}

\item{description}{A character description of the item.}

\item{tags}{A list of tags to sort the item. Tags are useful for
selecting sets of items and run bulk actions.}

\item{prj}{The name of a \code{project} item in the repository (see
\code{project}). Default is no associated project item.}

\item{src}{The name of the item that produced the stored
object. Usually a previously attached source code file.}

\item{chunk}{The name of the code chunk within \code{src} that is
responsible for building the item. Set to \code{name} by
default. See \code{build}.}

\item{replace}{If the item exists, overwrite the specified fields.}

\item{to}{An existing item name to attach the file to.}

\item{URL}{A URL where the item contents con be downloaded from.}
}
\value{
Used for side effects.
}
\description{
Create a new item from an existing file.
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)

\dontrun{
## Creating a PDF file with a figure.
pdf("afigure.pdf")
## Drawing a random plot in the figure
plot(runif(100), runif(100))
dev.off()
## Attaching the PDF file to the repo
rp$attach("afigure.pdf", "A plot of random numbers", "repo_sys")
## don't need the PDF file anymore
file.remove("afigure.pdf")
## Opening the stored PDF with Evince document viewer
rp$sys("afigure.pdf", "evince")
}

## wiping temporary repo
unlink(rp_path, TRUE)
}
