% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.sessionInfo.R
\name{report.sessionInfo}
\alias{report.sessionInfo}
\alias{report_packages}
\alias{cite_packages}
\alias{report_system}
\title{Report R environment (packages, system, etc.)}
\usage{
\method{report}{sessionInfo}(x, ...)

report_packages(session = NULL, include_R = TRUE, ...)

cite_packages(session = NULL, include_R = TRUE, ...)

report_system(session = NULL)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{...}{Arguments passed to or from other methods.}

\item{session}{A \link[utils:sessionInfo]{sessionInfo} object.}

\item{include_R}{Include R in the citations.}
}
\value{
\itemize{
  \item{For \code{report_packages}, a data frame of class with information on
  package name, version and citation.}
}

An object of class \code{\link{report}}.
}
\description{
Report R environment (packages, system, etc.)
}
\examples{
library(report)

session <- sessionInfo()

r <- report(session)
r
summary(r)
as.data.frame(r)
summary(as.data.frame(r))

# Convenience functions
report_packages(include_R = FALSE)
cite_packages(prefix = "> ")
report_system()
}
