% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rm_mvsum}
\alias{rm_mvsum}
\title{Format a regression model nicely for 'Rmarkdown'}
\usage{
rm_mvsum(
  model,
  data,
  digits = 2,
  covTitle = "",
  showN = FALSE,
  CIwidth = 0.95,
  vif = TRUE,
  caption = NULL,
  tableOnly = FALSE,
  p.adjust = "none",
  unformattedp = FALSE,
  chunk_label,
  nicenames = TRUE
)
}
\arguments{
\item{model}{model fit}

\item{data}{data that model was fit on (an attempt will be made to extract
this from the model)}

\item{digits}{number of digits to round estimates to, does not affect
p-values}

\item{covTitle}{character with the names of the covariate (predictor) column.
The default is to leave this empty for output or, for table only output to
use the column name 'Covariate'.}

\item{showN}{boolean indicating sample sizes should be shown for each
comparison, can be useful for interactions}

\item{CIwidth}{width for confidence intervals, defaults to 0.95}

\item{vif}{boolean indicating if the variance inflation factor should be
included. See details}

\item{caption}{table caption}

\item{tableOnly}{boolean indicating if unformatted table should be returned}

\item{p.adjust}{p-adjustments to be performed (Global p-values only)}

\item{unformattedp}{boolean indicating if you would like the p-value to be
returned unformatted (ie not rounded or prefixed with '<'). Should be used
in conjuction with the digits argument.}

\item{chunk_label}{only used if output is to Word to allow cross-referencing}

\item{nicenames}{boolean indicating if you want to replace . and _ in strings
with a space}
}
\value{
A character vector of the table source code, unless tableOnly=TRUE in
which case a data frame is returned
}
\description{
Multivariable (or univariate) regression models are re-formatted for
reporting and a global p-value is added for the evaluation of factor
variables.
}
\details{
Global p-values are likelihood ratio tests for lm, glm and polr models. For
lme models an attempt is made to re-fit the model using ML and if,successful
LRT is used to obtain a global p-value. For coxph models the model is re-run
without robust variances with and without each variable and a LRT is
presented. If unsuccessful a Wald p-value is returned. For GEE and CRR models
Wald global p-values are returned.

If the variance inflation factor is requested (VIF=T) then a generalised VIF
will be calculated in the same manner as the car package.

The number of decimals places to display the statistics can be changed with
digits, but this will not change the display of p-values. If more significant
digits are required for p-values then use tableOnly=TRUE and format as
desired.
}
\examples{
glm_fit = glm(change_ctdna_group~sex:age+baseline_ctdna+l_size,
data=pembrolizumab,family = 'binomial')
rm_mvsum(glm_fit)

#linear model with p-value adjustment
lm_fit=lm(baseline_ctdna~age+sex+l_size+tmb,data=pembrolizumab)
rm_mvsum(lm_fit,p.adjust = "bonferroni")
#Coxph
require(survival)
res.cox <- coxph(Surv(os_time, os_status) ~ sex+age+l_size+tmb, data = pembrolizumab)
rm_mvsum(res.cox, vif=TRUE)
}
\references{
John Fox & Georges Monette (1992) Generalized Collinearity
Diagnostics, Journal of the American Statistical Association, 87:417,
178-183, DOI: 10.1080/01621459.1992.10475190

John Fox and Sanford Weisberg (2019). An {R} Companion to
Applied Regression, Third Edition. Thousand Oaks CA: Sage. URL:
https://socialsciences.mcmaster.ca/jfox/Books/Companion
}
