% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust_comp.R
\name{clust_composite}
\alias{clust_composite}
\title{Composite record from a cluster using a weighted average of each column values.}
\usage{
clust_composite(
  cluster,
  col_type,
  weights = rep(1/nrow(cluster), nrow(cluster))
)
}
\arguments{
\item{cluster}{A data frame of the clustered records}

\item{col_type}{A vector encoding the column type for each column in the dataset. Can take values
in "categorical", "ordinal", "string", or "numeric"}

\item{weights}{A vector of length equal to the number of records in the cluster indicating the
weight for each. Defaults to equal weight.}
}
\value{
Returns the composite record from an individual cluster.

#' @examples
data("rl_reg1")

clusters <- split(rl_reg1, identity.rl_reg1)
type <- c("string", "string", "numeric", "numeric",
    "numeric", "categorical", "ordinal", "numeric", "numeric")

clust_composite(clusters[[1]], type)
}
\description{
Composite record from a cluster using a weighted average of each column values.
}
