% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postProcess.R
\name{writeOutputs}
\alias{writeOutputs}
\alias{writeOutputs.Raster}
\alias{writeOutputs.Spatial}
\alias{writeOutputs.sf}
\alias{writeOutputs.quosure}
\alias{writeOutputs.default}
\title{Write module inputs on disk}
\usage{
writeOutputs(
  x,
  filename2,
  overwrite = getOption("reproducible.overwrite", NULL),
  ...
)

\method{writeOutputs}{Raster}(
  x,
  filename2 = NULL,
  overwrite = getOption("reproducible.overwrite", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  ...
)

\method{writeOutputs}{Spatial}(
  x,
  filename2 = NULL,
  overwrite = getOption("reproducible.overwrite", TRUE),
  ...
)

\method{writeOutputs}{sf}(
  x,
  filename2 = NULL,
  overwrite = getOption("reproducible.overwrite", FALSE),
  verbose = getOption("reproducible.verbose", 1),
  ...
)

\method{writeOutputs}{quosure}(x, filename2, ...)

\method{writeOutputs}{default}(x, filename2, ...)
}
\arguments{
\item{x}{The object save to disk i.e., write outputs}

\item{filename2}{File name passed to \code{\link[raster:writeRaster]{raster::writeRaster()}}, or
\code{\link[raster:shapefile]{raster::shapefile()}} or \code{\link[sf:st_write]{sf::st_write()}}
(\code{dsn} argument).}

\item{overwrite}{Logical. Should file being written overwrite an existing file if it exists.}

\item{...}{Passed into \code{\link[raster:shapefile]{raster::shapefile()}} or
\code{\link[raster:writeRaster]{raster::writeRaster()}} or \code{\link[sf:st_write]{sf::st_write()}}}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}
}
\value{
A GIS file (e.g., RasterLayer, SpatRaster etc.) that has been
appropriately written to disk. In the case of vector datasets, this will
be a side effect. In the case of gridded objects (Raster*, SpatRaster), the
object will have a file-backing.
}
\description{
Can be used to write prepared inputs on disk.
}
\examples{
library(sp)
library(raster)
r <- raster::raster(extent(0,100,0,100), vals = 1:1e2)

tf <- tempfile(fileext = ".tif")
writeOutputs(r, tf)
}
\author{
Eliot McIntire and Jean Marchal
}
