% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.prefix}
\alias{.prefix}
\alias{suffix}
\alias{.suffix}
\title{Add a prefix or suffix to the basename part of a file path}
\usage{
.prefix(f, prefix = "")

.suffix(f, suffix = "")
}
\arguments{
\item{f}{A character string giving the name/path of a file.}

\item{prefix}{A character string to prepend to the filename.}

\item{suffix}{A character string to postpend to the filename.}
}
\description{
Prepend (or postpend) a filename with a prefix (or suffix).
If the directory name of the file cannot be ascertained from its path,
it is assumed to be in the current working directory.
}
\examples{
# file's full path is specified (i.e., dirname is known)
myFile <- file.path("~/data", "file.tif")
.prefix(myFile, "small_")    ## "/home/username/data/small_file.tif"
.suffix(myFile, "_cropped") ## "/home/username/data/myFile_cropped.shp"

# file's full path is not specified
.prefix("myFile.shp", "small")    ## "./small_myFile.shp"
.suffix("myFile.shp", "_cropped") ## "./myFile_cropped.shp"

}
\author{
Jean Marchal and Alex Chubaty
}
