% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\docType{class}
\name{Path-class}
\alias{Path-class}
\alias{asPath}
\alias{asPath.character}
\alias{asPath.null}
\title{Coerce a character string to a class "Path"}
\usage{
asPath(obj, nParentDirs = 0)

\method{asPath}{character}(obj, nParentDirs = 0)

\method{asPath}{null}(obj, nParentDirs = 0)
}
\arguments{
\item{obj}{A character string to convert to a \code{Path}.}

\item{nParentDirs}{A numeric indicating the number of parent directories starting
from basename(obj) = 0 to keep for the digest}
}
\value{
A vector of class \code{Path}, which is similar to a character, but
has an attribute indicating how deep the Path should be
considered "digestible". In other words, most of the time, only some
component of an absolute path is relevant for evaluating its purpose in
a Cache situation. In general, this is usually equivalent to just the "relative" path
}
\description{
Allows a user to specify that their character string is indeed a filepath.
Thus, methods that require only a filepath can be dispatched correctly.
}
\details{
It is often difficult or impossible to know algorithmically whether a
character string corresponds to a valid filepath.
In the case where it is en existing file, \code{file.exists} can work.
But if it does not yet exist, e.g., for a \code{save}, it is difficult to know
whether it is a valid path before attempting to save to the path.

This function can be used to remove any ambiguity about whether a character
string is a path. It is primarily useful for achieving repeatability with Caching.
Essentially, when Caching, arguments that are character strings should generally be
digested verbatim, i.e., it must be an exact copy for the Cache mechanism
to detect a candidate for recovery from the cache.
Paths, are different. While they are character strings, there are many ways to
write the same path. Examples of identical meaning, but different character strings are:
path expanding of \code{~} vs. not, double back slash vs. single forward slash,
relative path vs. absolute path.
All of these should be assessed for their actual file or directory location,
NOT their character string. By converting all character string that are actual
file or directory paths with this function, then \code{Cache} will correctly assess
the location, NOT the character string representation.
}
\examples{
tmpf <- tempfile(fileext = ".csv")
file.exists(tmpf) ## FALSE
tmpfPath <- asPath(tmpf)
is(tmpf, "Path") ## FALSE
is(tmpfPath, "Path") ## TRUE

}
