# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title A fast distance algorithm for two matrices written in C++ 
#' @description Computes distances between two data matrices using "euclid", "cor", "cosine" 
#' @usage 
#' fastDist(X,Y,method)
#' @param X a \code{matrix}
#' @param Y a \code{matrix}
#' @param method a \code{string} with possible values "euclid", "cor", "cosine"
#' @return a distance \code{matrix}
#' @keywords internal
#' @useDynLib resemble
#' @author Antoine Stevens and Leonardo Ramirez-Lopez
fastDist <- function(X, Y, method) {
    .Call('resemble_fastDist', PACKAGE = 'resemble', X, Y, method)
}

#' @title A fast distance algorithm for a matrix and a vector written in C++ 
#' @usage 
#' fastDistV(X,Y,method)
#' @param X a \code{matrix}
#' @param Y a \code{vector}
#' @param method a \code{string} with possible values "euclid", "cor", "cosine"
#' @return a distance \code{vector}
#' @author Antoine Stevens and Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib resemble
fastDistV <- function(X, Y, method) {
    .Call('resemble_fastDistV', PACKAGE = 'resemble', X, Y, method)
}

#' @title A fast (parallel) algorithm of (squared) Euclidean cross-distance for vectors written in C++ 
#' @usage 
#' fastDistVV(X, cores)
#' @param X a \code{vector}
#' @return a \code{vector} of distance (lower triangle of the distance matrix, stored by column)
#' @details used internally in orthoProjection
#' @author Antoine Stevens
#' @keywords internal 
#' @useDynLib resemble
fastDistVV <- function(X, cores) {
    .Call('resemble_fastDistVV', PACKAGE = 'resemble', X, cores)
}

#' @title Moving/rolling correlation distance of two matrices
#' @description Computes a moving window correlation distance between two data matrices
#' @usage 
#' movcorDist(X,Y,w)
#' @param X a \code{matrix}
#' @param Y a \code{matrix}
#' @param w window size (must be odd)
#' @return a \code{matrix} of correlation distance
#' @author Leonardo Ramirez-Lopez and Antoine Stevens
movcorDist <- function(X, Y, w) {
    .Call('resemble_movcorDist', PACKAGE = 'resemble', X, Y, w)
}

#' @title A function to compute row-wise index of minimum values of a square distance matrix
#' @usage 
#' which_min(X,cores)
#' @param X a square \code{matrix} of distance
#' @param cores number of cores used to run the computation
#' @return a \code{vector} of the indices of the minimum value in each row of the input \code{matrix}
#' @details Used internally to find the nearest neighbours
#' @keywords internal
#' @useDynLib resemble
#' @author Antoine Stevens 
which_min <- function(X, cores) {
    .Call('resemble_which_min', PACKAGE = 'resemble', X, cores)
}

#' @title A function to compute indices of minimum values of a distance vector
#' @usage 
#' which_minV(X,cores)
#' @param X a \code{vector} of distance (as computed in \code{resemble:::fastDistVV} or \code{base::dist})
#' @param cores number of cores used to run the computation
#' @return a \code{vector} of the indices of the nearest neighbours
#' @details 
#' Used internally to find the nearest neighbours. 
#' It searches in lower (or upper?) trianguular matrix. Therefore this must be the format of the 
#' input data. The piece of code int \code{len = (sqrt(X.size()*8+1)+1)/2} generated an error in CRAN
#' since \code{sqrt} cannot be applied to integers.
#' @keywords internal
#' @useDynLib resemble
#' @author Antoine Stevens 
which_minV <- function(X, cores) {
    .Call('resemble_which_minV', PACKAGE = 'resemble', X, cores)
}

