% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softmax.R
\name{softmax}
\alias{softmax}
\alias{dsoftmax}
\title{Soft-Max function}
\usage{
softmax(x)

dsoftmax(x)
}
\arguments{
\item{x}{A numeric vector or matrix}
}
\value{
\code{softmax} returns the softmax of \code{x}; rowwise if \code{x} is a matrix.

\code{dsoftmax} returns the Jacobi-matrix of \code{softmax(x)} at \code{x}. \code{x} must be a vector.
}
\description{
Softmax for a vector x is defined as
}
\details{
\eqn{s_i = \exp(x_i) / \sum_k \exp(x_k)}

It satisfies \code{sum(s) == 1.0} and can be used to smoothly enforce a sum
constraint.
}
\examples{
softmax(c(5, 5))
softmax(diag(nrow = 5, ncol = 6))
}
