/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.constraints;

import java.util.Arrays;
import org.restopt.RestoptProblem;
import org.restopt.constraints.AbstractRestoptConstraint;
import org.restopt.exception.RestoptException;

public class RestorableAreaConstraint
extends AbstractRestoptConstraint {
    protected int minAreaToRestore;
    protected int maxAreaToRestore;
    protected int[] cellArea;
    protected double minProportion;
    protected int[] minArea;

    public RestorableAreaConstraint(RestoptProblem restoptProblem, int minAreaToRestore, int maxAreaToRestore, double minProportion) throws RestoptException {
        super(restoptProblem);
        this.minAreaToRestore = minAreaToRestore;
        this.maxAreaToRestore = maxAreaToRestore;
        this.cellArea = restoptProblem.getData().getCellAreaData();
        this.minProportion = minProportion;
        this.problem.setRestorableAreaConstraint(this);
    }

    @Override
    public void post() {
        assert (this.minProportion >= 0.0 && this.minProportion <= 1.0);
        int[] pus = this.problem.getAvailablePlanningUnits();
        this.minArea = new int[pus.length];
        int[] maxRestorableArea = new int[pus.length];
        int maxCellArea = 0;
        int offset = this.problem.getGrid().getNbGroups();
        for (int i = 0; i < this.problem.getAvailablePlanningUnits().length; ++i) {
            int restorable;
            int cell = pus[i];
            int completeUngroupedIndex = this.getGrid().getUngroupedCompleteIndex(cell);
            int cArea = this.cellArea[completeUngroupedIndex];
            maxCellArea = maxCellArea < cArea ? cArea : maxCellArea;
            int threshold = (int)Math.ceil((double)cArea * (1.0 - this.minProportion));
            maxRestorableArea[cell - offset] = restorable = this.problem.getRestorableArea(cell);
            this.minArea[cell - offset] = restorable <= threshold ? 0 : restorable - threshold;
        }
        this.problem.minRestore = this.getModel().intVar(this.minAreaToRestore, this.maxAreaToRestore);
        this.problem.totalRestorable = this.getModel().intVar(0, pus.length * maxCellArea);
        this.getModel().sumElements(this.getRestoreSetVar(), this.minArea, offset, this.problem.minRestore).post();
        this.getModel().sumElements(this.getRestoreSetVar(), maxRestorableArea, offset, this.problem.totalRestorable).post();
    }

    public int[] getCardinalityBounds() {
        int[] areas = Arrays.copyOf(this.minArea, this.minArea.length);
        Arrays.sort(areas);
        int UB = 0;
        int sum = 0;
        for (int i : areas) {
            if ((sum += i) > this.maxAreaToRestore) break;
            ++UB;
        }
        int LB = 0;
        sum = 0;
        boolean started = false;
        for (int i = areas.length - 1; i >= 0; --i) {
            if (!started) {
                if (areas[i] > this.maxAreaToRestore) continue;
                started = true;
                ++LB;
                sum += areas[i];
                continue;
            }
            if ((sum += areas[i]) > this.maxAreaToRestore) break;
            ++LB;
        }
        return new int[]{LB, UB};
    }

    public int getMinArea(int pu) {
        return this.minArea[pu - this.problem.getGrid().getNbGroups()];
    }
}

