/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.binary.PropGreaterOrEqualX_Y;
import org.chocosolver.solver.constraints.graph.basic.PropAntiSymmetric;
import org.chocosolver.solver.constraints.graph.basic.PropDiameter;
import org.chocosolver.solver.constraints.graph.basic.PropLoopSet;
import org.chocosolver.solver.constraints.graph.basic.PropNbCliques;
import org.chocosolver.solver.constraints.graph.basic.PropNbEdges;
import org.chocosolver.solver.constraints.graph.basic.PropNbLoops;
import org.chocosolver.solver.constraints.graph.basic.PropNbNodes;
import org.chocosolver.solver.constraints.graph.basic.PropSymmetric;
import org.chocosolver.solver.constraints.graph.basic.PropTransitivity;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropEdgeBoolChannel;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighBoolChannel;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighBoolsChannel1;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighBoolsChannel2;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighSetChannel;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighSetsChannel1;
import org.chocosolver.solver.constraints.graph.channeling.edges.PropNeighSetsChannel2;
import org.chocosolver.solver.constraints.graph.channeling.nodes.PropNodeBoolChannel;
import org.chocosolver.solver.constraints.graph.channeling.nodes.PropNodeBoolsChannel;
import org.chocosolver.solver.constraints.graph.channeling.nodes.PropNodeSetChannel;
import org.chocosolver.solver.constraints.graph.connectivity.PropBiconnected;
import org.chocosolver.solver.constraints.graph.connectivity.PropConnected;
import org.chocosolver.solver.constraints.graph.connectivity.PropNbCC;
import org.chocosolver.solver.constraints.graph.connectivity.PropNbSCC;
import org.chocosolver.solver.constraints.graph.connectivity.PropSizeMaxCC;
import org.chocosolver.solver.constraints.graph.connectivity.PropSizeMinCC;
import org.chocosolver.solver.constraints.graph.cost.trees.PropMaxDegVarTree;
import org.chocosolver.solver.constraints.graph.cost.trees.PropTreeCostSimple;
import org.chocosolver.solver.constraints.graph.cost.trees.lagrangian.PropGenericLagrDCMST;
import org.chocosolver.solver.constraints.graph.cost.tsp.PropCycleCostSimple;
import org.chocosolver.solver.constraints.graph.cost.tsp.lagrangian.PropLagrOneTree;
import org.chocosolver.solver.constraints.graph.cycles.PropAcyclic;
import org.chocosolver.solver.constraints.graph.cycles.PropCycle;
import org.chocosolver.solver.constraints.graph.degree.PropNodeDegreeAtLeastIncr;
import org.chocosolver.solver.constraints.graph.degree.PropNodeDegreeAtMostIncr;
import org.chocosolver.solver.constraints.graph.degree.PropNodeDegreeVar;
import org.chocosolver.solver.constraints.graph.inclusion.PropInclusion;
import org.chocosolver.solver.constraints.graph.symmbreaking.PropIncrementalAdjacencyMatrix;
import org.chocosolver.solver.constraints.graph.symmbreaking.PropIncrementalAdjacencyUndirectedMatrix;
import org.chocosolver.solver.constraints.graph.symmbreaking.PropSymmetryBreaking;
import org.chocosolver.solver.constraints.graph.symmbreaking.PropSymmetryBreakingEx;
import org.chocosolver.solver.constraints.graph.tree.PropArborescence;
import org.chocosolver.solver.constraints.graph.tree.PropArborescences;
import org.chocosolver.solver.constraints.graph.tree.PropReachability;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IncidentSet;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.util.objects.graphs.Orientation;
import org.chocosolver.util.tools.ArrayUtils;

public interface IGraphConstraintFactory
extends ISelf<Model> {
    default public Constraint nbNodes(GraphVar g, IntVar nb) {
        return new Constraint("nbNodes", new PropNbNodes(g, nb));
    }

    default public Constraint nbEdges(GraphVar g, IntVar nb) {
        return new Constraint("nbEdges", new PropNbEdges(g, nb));
    }

    default public Constraint loopSet(GraphVar g, SetVar loops) {
        return new Constraint("loopSet", new PropLoopSet(g, loops));
    }

    default public Constraint nbLoops(GraphVar g, IntVar nb) {
        return new Constraint("nbLoops", new PropNbLoops(g, nb));
    }

    default public Constraint symmetric(DirectedGraphVar g) {
        return new Constraint("symmetric", new PropSymmetric(g));
    }

    default public Constraint antisymmetric(DirectedGraphVar g) {
        return new Constraint("antisymmetric", new PropAntiSymmetric(g));
    }

    default public Constraint transitivity(GraphVar g) {
        return new Constraint("transitivity", new PropTransitivity<GraphVar>(g));
    }

    default public Constraint subgraph(UndirectedGraphVar g1, UndirectedGraphVar g2) {
        return new Constraint("subgraph", new PropInclusion(g1, g2));
    }

    default public Constraint subgraph(DirectedGraphVar g1, DirectedGraphVar g2) {
        return new Constraint("subgraph", new PropInclusion(g1, g2));
    }

    default public Constraint nodesChanneling(GraphVar g, SetVar nodes) {
        return new Constraint("nodesSetChanneling", new PropNodeSetChannel(nodes, g));
    }

    default public Constraint nodesChanneling(GraphVar g, BoolVar[] nodes) {
        return new Constraint("nodesBoolsChanneling", new PropNodeBoolsChannel(nodes, g));
    }

    default public Constraint nodeChanneling(GraphVar g, BoolVar isIn, int vertex) {
        return new Constraint("nodesBoolChanneling", new PropNodeBoolChannel(isIn, vertex, g));
    }

    default public Constraint edgeChanneling(DirectedGraphVar g, BoolVar isEdge, int from, int to) {
        return new Constraint("edgeChanneling", new PropEdgeBoolChannel(isEdge, from, to, g));
    }

    default public Constraint edgeChanneling(UndirectedGraphVar g, BoolVar isEdge, int i, int j) {
        return new Constraint("edgeChanneling", new PropEdgeBoolChannel(isEdge, i, j, g));
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g, SetVar[] neighbors) {
        return new Constraint("neighSetsChanneling", new PropNeighSetsChannel1(neighbors, g), new PropNeighSetsChannel2(neighbors, g));
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g, BoolVar[][] neighbors) {
        return new Constraint("neighBoolsChanneling", new PropNeighBoolsChannel1(neighbors, g), new PropNeighBoolsChannel2(neighbors, g));
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g, SetVar neighborsOf, int node) {
        return new Constraint("neighSetChanneling", new PropNeighSetChannel(neighborsOf, node, g, new IncidentSet.SuccessorsSet()));
    }

    default public Constraint neighborsChanneling(UndirectedGraphVar g, BoolVar[] neighborsOf, int node) {
        return new Constraint("neighBoolChanneling", new PropNeighBoolChannel(neighborsOf, node, g, new IncidentSet.SuccessorsSet()));
    }

    default public Constraint successorsChanneling(DirectedGraphVar g, SetVar[] successors) {
        return new Constraint("succSetsChanneling", new PropNeighSetsChannel1(successors, g), new PropNeighSetsChannel2(successors, g));
    }

    default public Constraint successorsChanneling(DirectedGraphVar g, BoolVar[][] successors) {
        return new Constraint("succBoolsChanneling", new PropNeighBoolsChannel1(successors, g), new PropNeighBoolsChannel2(successors, g));
    }

    default public Constraint successorsChanneling(DirectedGraphVar g, SetVar successorsOf, int node) {
        return new Constraint("succSetChanneling", new PropNeighSetChannel(successorsOf, node, g, new IncidentSet.SuccessorsSet()));
    }

    default public Constraint successorsChanneling(DirectedGraphVar g, BoolVar[] successorsOf, int node) {
        return new Constraint("succBoolChanneling", new PropNeighBoolChannel(successorsOf, node, g, new IncidentSet.SuccessorsSet()));
    }

    default public Constraint predecessorsChanneling(DirectedGraphVar g, SetVar predecessorsOf, int node) {
        return new Constraint("predSetChanneling", new PropNeighSetChannel(predecessorsOf, node, g, new IncidentSet.PredecessorsSet()));
    }

    default public Constraint predecessorsChanneling(DirectedGraphVar g, BoolVar[] predecessorsOf, int node) {
        return new Constraint("predBoolChanneling", new PropNeighBoolChannel(predecessorsOf, node, g, new IncidentSet.PredecessorsSet()));
    }

    default public Constraint minDegree(UndirectedGraphVar g, int minDegree) {
        return new Constraint("minDegree", new PropNodeDegreeAtLeastIncr(g, minDegree));
    }

    default public Constraint minDegrees(UndirectedGraphVar g, int[] minDegrees) {
        return new Constraint("minDegrees", new PropNodeDegreeAtLeastIncr(g, minDegrees));
    }

    default public Constraint maxDegree(UndirectedGraphVar g, int maxDegree) {
        return new Constraint("maxDegree", new PropNodeDegreeAtMostIncr(g, maxDegree));
    }

    default public Constraint maxDegrees(UndirectedGraphVar g, int[] maxDegrees) {
        return new Constraint("maxDegrees", new PropNodeDegreeAtMostIncr(g, maxDegrees));
    }

    default public Constraint degrees(UndirectedGraphVar g, IntVar[] degrees) {
        return new Constraint("degrees", new PropNodeDegreeVar(g, degrees));
    }

    default public Constraint minInDegree(DirectedGraphVar g, int minDegree) {
        return new Constraint("minInDegree", new PropNodeDegreeAtLeastIncr(g, Orientation.PREDECESSORS, minDegree));
    }

    default public Constraint minInDegrees(DirectedGraphVar g, int[] minDegrees) {
        return new Constraint("minInDegrees", new PropNodeDegreeAtLeastIncr(g, Orientation.PREDECESSORS, minDegrees));
    }

    default public Constraint maxInDegree(DirectedGraphVar g, int maxDegree) {
        return new Constraint("maxInDegree", new PropNodeDegreeAtMostIncr(g, Orientation.PREDECESSORS, maxDegree));
    }

    default public Constraint maxInDegrees(DirectedGraphVar g, int[] maxDegrees) {
        return new Constraint("maxInDegrees", new PropNodeDegreeAtMostIncr(g, Orientation.PREDECESSORS, maxDegrees));
    }

    default public Constraint inDegrees(DirectedGraphVar g, IntVar[] degrees) {
        return new Constraint("inDegrees", new PropNodeDegreeVar(g, Orientation.PREDECESSORS, degrees));
    }

    default public Constraint minOutDegree(DirectedGraphVar g, int minDegree) {
        return new Constraint("minOutDegrees", new PropNodeDegreeAtLeastIncr(g, Orientation.SUCCESSORS, minDegree));
    }

    default public Constraint minOutDegrees(DirectedGraphVar g, int[] minDegrees) {
        return new Constraint("minOutDegrees", new PropNodeDegreeAtLeastIncr(g, Orientation.SUCCESSORS, minDegrees));
    }

    default public Constraint maxOutDegree(DirectedGraphVar g, int maxDegree) {
        return new Constraint("maxOutDegrees", new PropNodeDegreeAtMostIncr(g, Orientation.SUCCESSORS, maxDegree));
    }

    default public Constraint maxOutDegrees(DirectedGraphVar g, int[] maxDegrees) {
        return new Constraint("maxOutDegrees", new PropNodeDegreeAtMostIncr(g, Orientation.SUCCESSORS, maxDegrees));
    }

    default public Constraint outDegrees(DirectedGraphVar g, IntVar[] degrees) {
        return new Constraint("outDegrees", new PropNodeDegreeVar(g, Orientation.SUCCESSORS, degrees));
    }

    default public Constraint cycle(UndirectedGraphVar g) {
        int m = 0;
        int n = g.getNbMaxNodes();
        for (int i = 0; i < n; ++i) {
            m += g.getPotentialNeighborsOf(i).size();
        }
        m /= 2;
        PropNodeDegreeAtMostIncr pMaxDeg = new PropNodeDegreeAtMostIncr(g, 2);
        if (g.getMandatoryNodes().size() <= 1) {
            IntVar nbNodes = g.getModel().intVar(g.getMandatoryNodes().size(), g.getPotentialNodes().size());
            g.getModel().ifThenElse(g.getModel().intGeView(nbNodes, 2), new Constraint("minDeg >= 2", new PropNodeDegreeAtLeastIncr(g, 2)), new Constraint("minDeg >= 1", new PropNodeDegreeAtLeastIncr(g, 1)));
            return new Constraint("cycle", new PropNbNodes(g, nbNodes), pMaxDeg, new PropConnected(g), new PropCycle(g));
        }
        return new Constraint("cycle", new PropNodeDegreeAtLeastIncr(g, 2), pMaxDeg, new PropConnected(g), new PropCycle(g));
    }

    default public Constraint noCycle(UndirectedGraphVar g) {
        return new Constraint("noCycle", new PropAcyclic(g));
    }

    default public Constraint noCircuit(DirectedGraphVar g) {
        return new Constraint("noCycle", new PropAcyclic(g));
    }

    default public Constraint connected(UndirectedGraphVar g) {
        return new Constraint("connected", new PropConnected(g));
    }

    default public Constraint biconnected(UndirectedGraphVar g) {
        return new Constraint("connected", new PropBiconnected(g));
    }

    default public Constraint nbConnectedComponents(UndirectedGraphVar g, IntVar nb) {
        return new Constraint("NbCC", new PropNbCC(g, nb));
    }

    default public Constraint sizeConnectedComponents(UndirectedGraphVar g, IntVar sizeMinCC, IntVar sizeMaxCC) {
        return new Constraint("SizeCC", new PropGreaterOrEqualX_Y(new IntVar[]{sizeMaxCC, sizeMinCC}), new PropSizeMinCC(g, sizeMinCC), new PropSizeMaxCC(g, sizeMaxCC));
    }

    default public Constraint sizeMinConnectedComponents(UndirectedGraphVar g, IntVar sizeMinCC) {
        return new Constraint("SizeMinCC", new PropSizeMinCC(g, sizeMinCC));
    }

    default public Constraint sizeMaxConnectedComponents(UndirectedGraphVar g, IntVar sizeMaxCC) {
        return new Constraint("SizeMaxCC", new PropSizeMaxCC(g, sizeMaxCC));
    }

    default public Constraint stronglyConnected(DirectedGraphVar g) {
        return this.nbStronglyConnectedComponents(g, g.getModel().intVar(1));
    }

    default public Constraint nbStronglyConnectedComponents(DirectedGraphVar g, IntVar nb) {
        return new Constraint("NbSCC", new PropNbSCC(g, nb));
    }

    default public Constraint tree(UndirectedGraphVar g) {
        return new Constraint("tree", new PropAcyclic(g), new PropConnected(g));
    }

    default public Constraint forest(UndirectedGraphVar g) {
        return new Constraint("forest", new PropAcyclic(g));
    }

    default public Constraint directedTree(DirectedGraphVar g, int root) {
        int n = g.getNbMaxNodes();
        int[] nbPreds = new int[n];
        for (int i = 0; i < n; ++i) {
            nbPreds[i] = 1;
        }
        nbPreds[root] = 0;
        return new Constraint("directedTree", new PropArborescence(g, root), new PropNodeDegreeAtMostIncr(g, Orientation.PREDECESSORS, nbPreds), new PropNodeDegreeAtLeastIncr(g, Orientation.PREDECESSORS, nbPreds));
    }

    default public Constraint directedForest(DirectedGraphVar g) {
        return new Constraint("directedForest", new PropArborescences(g), new PropNodeDegreeAtMostIncr(g, Orientation.PREDECESSORS, 1));
    }

    default public Constraint reachability(DirectedGraphVar g, int root) {
        return new Constraint("reachability_from_" + root, new PropReachability(g, root));
    }

    default public Constraint nbCliques(UndirectedGraphVar g, IntVar nb) {
        return new Constraint("NbCliques", new PropTransitivity<UndirectedGraphVar>(g), new PropNbCC(g, nb), new PropNbCliques(g, nb));
    }

    default public Constraint diameter(UndirectedGraphVar g, IntVar d) {
        return new Constraint("diameter", new PropConnected(g), new PropDiameter(g, d));
    }

    default public Constraint diameter(DirectedGraphVar g, IntVar d) {
        return new Constraint("NbCliques", new PropNbSCC(g, g.getModel().intVar(1)), new PropDiameter(g, d));
    }

    default public Constraint tsp(UndirectedGraphVar graphVar, IntVar costVar, int[][] edgeCosts, int lagrMode) {
        Propagator[] props = ArrayUtils.append(this.cycle(graphVar).getPropagators(), {new PropCycleCostSimple(graphVar, costVar, edgeCosts)});
        if (lagrMode > 0) {
            PropLagrOneTree hk = new PropLagrOneTree(graphVar, costVar, edgeCosts);
            hk.waitFirstSolution(lagrMode == 2);
            props = ArrayUtils.append(props, {hk});
        }
        return new Constraint("TSP", props);
    }

    default public Constraint dcmst(UndirectedGraphVar graphVar, IntVar[] degrees, IntVar costVar, int[][] edgeCosts, int lagrMode) {
        Propagator[] props = ArrayUtils.append(this.tree(graphVar).getPropagators(), {new PropTreeCostSimple(graphVar, costVar, edgeCosts), new PropMaxDegVarTree(graphVar, degrees)});
        if (lagrMode > 0) {
            PropGenericLagrDCMST hk = new PropGenericLagrDCMST(graphVar, costVar, degrees, edgeCosts, lagrMode == 2);
            props = ArrayUtils.append(props, {hk});
        }
        return new Constraint("dcmst", props);
    }

    default public void postSymmetryBreaking(DirectedGraphVar graph) {
        int i;
        Model m = (Model)this.ref();
        int n = graph.getNbMaxNodes();
        BoolVar[] t = m.boolVarArray("T[]", n * n);
        IntVar[] p = new IntVar[n];
        p[0] = m.intVar("P[0]", 0);
        for (i = 1; i < n; ++i) {
            p[i] = m.intVar("P[" + i + "]", 0, i - 1);
        }
        new Constraint("AdjacencyMatrix", new PropIncrementalAdjacencyMatrix(graph, t)).post();
        for (i = 0; i < n - 1; ++i) {
            IntVar I = m.intVar(i);
            for (int j = 1; j < n; ++j) {
                BoolVar[] clause = new BoolVar[i + 1];
                clause[i] = t[i + j * n];
                for (int k = 0; k < i; ++k) {
                    clause[k] = t[k + j * n].not();
                }
                Constraint c = m.and(clause);
                Constraint pij = m.arithm(p[j], "=", I);
                m.ifThen(pij, c);
                m.ifThen(c, pij);
            }
        }
        for (i = 1; i < n - 1; ++i) {
            m.arithm(p[i], "<=", p[i + 1]).post();
        }
    }

    default public void postSymmetryBreaking(UndirectedGraphVar graph) {
        int i;
        Model m = (Model)this.ref();
        int n = graph.getNbMaxNodes();
        BoolVar[] t = m.boolVarArray("T[]", n * n);
        IntVar[] p = new IntVar[n];
        p[0] = m.intVar("P[0]", 0);
        for (i = 1; i < n; ++i) {
            p[i] = m.intVar("P[" + i + "]", 0, i - 1);
        }
        new Constraint("AdjacencyMatrix", new PropIncrementalAdjacencyUndirectedMatrix(graph, t)).post();
        for (i = 0; i < n - 1; ++i) {
            IntVar I = m.intVar(i);
            for (int j = 1; j < n; ++j) {
                BoolVar[] clause = new BoolVar[i + 1];
                clause[i] = t[i + j * n];
                for (int k = 0; k < i; ++k) {
                    clause[k] = t[k + j * n].not();
                }
                Constraint c = m.and(clause);
                Constraint pij = m.arithm(p[j], "=", I);
                m.ifThen(pij, c);
                m.ifThen(c, pij);
            }
        }
        for (i = 1; i < n - 1; ++i) {
            m.arithm(p[i], "<=", p[i + 1]).post();
        }
    }

    default public Constraint symmetryBreaking2(UndirectedGraphVar graph) {
        int n = graph.getNbMaxNodes();
        BoolVar[] t = ((Model)this.ref()).boolVarArray("T[]", n * n);
        return new Constraint("symmBreak", new PropIncrementalAdjacencyUndirectedMatrix(graph, t), new PropSymmetryBreaking(t));
    }

    default public Constraint symmetryBreaking3(UndirectedGraphVar graph) {
        int n = graph.getNbMaxNodes();
        BoolVar[] t = ((Model)this.ref()).boolVarArray("T[]", n * n);
        return new Constraint("symmBreakEx", new PropIncrementalAdjacencyUndirectedMatrix(graph, t), new PropSymmetryBreakingEx(t));
    }
}

