/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.assignments.GraphDecisionOperator;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.selectors.values.graph.edge.GraphEdgeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.node.GraphNodeSelector;
import org.chocosolver.solver.search.strategy.selectors.values.graph.priority.GraphNodeOrEdgeSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.Variable;

public class GraphStrategy
extends AbstractStrategy<GraphVar> {
    protected VariableSelector<GraphVar> varSelector;
    private final GraphNodeOrEdgeSelector nodeOrEdgeSelector;
    protected GraphNodeSelector nodeSelector;
    protected GraphEdgeSelector edgeSelector;
    protected GraphDecisionOperator operator;

    public GraphStrategy(GraphVar[] scope, VariableSelector<GraphVar> varSelector, GraphNodeOrEdgeSelector nodeOrEdgeSelector, GraphNodeSelector nodeSelector, GraphEdgeSelector edgeSelector, boolean enforceFirst) {
        super((Variable[])scope);
        this.varSelector = varSelector;
        this.nodeOrEdgeSelector = nodeOrEdgeSelector;
        this.nodeSelector = nodeSelector;
        this.edgeSelector = edgeSelector;
        this.operator = enforceFirst ? DecisionOperatorFactory.makeGraphEnforce() : DecisionOperatorFactory.makeGraphRemove();
    }

    @Override
    public Decision<GraphVar> getDecision() {
        GraphVar variable = (GraphVar)this.varSelector.getVariable((GraphVar[])this.vars);
        return this.computeDecision(variable);
    }

    @Override
    public Decision<GraphVar> computeDecision(GraphVar g) {
        if (g == null) {
            return null;
        }
        assert (!g.isInstantiated());
        if (this.nodeOrEdgeSelector.nextIsNode(g)) {
            return g.getModel().getSolver().getDecisionPath().makeGraphNodeDecision(g, this.operator, this.nodeSelector.selectNode(g));
        }
        int[] edge = this.edgeSelector.selectEdge(g);
        assert (edge.length == 2);
        return g.getModel().getSolver().getDecisionPath().makeGraphEdgeDecision(g, this.operator, edge[0], edge[1]);
    }
}

