% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CountSet.R
\name{CountSet}
\alias{CountSet}
\title{Subclass of \code{\link{FeatureSet}} to represent counts centred
on points}
\description{
A CountSet contains information about points located
  on \code{\link{Outline}}s. Each CountSet contains a list of
  matrices, each of which has columns labelled \code{X} and
  \code{Y} describing the cartesian coordinates (in the unscaled
  coordinate frame) of the centres of boxes in the Outline, and a
  column \code{C} representing the counts in those boxes.
}
\author{
David Sterratt
}
\section{Super classes}{
\code{\link[retistruct:FeatureSetCommon]{retistruct::FeatureSetCommon}} -> \code{\link[retistruct:FeatureSet]{retistruct::FeatureSet}} -> \code{CountSet}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CountSet-new}{\code{CountSet$new()}}
\item \href{#method-CountSet-reconstruct}{\code{CountSet$reconstruct()}}
\item \href{#method-CountSet-clone}{\code{CountSet$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getCol"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getCol'><code>retistruct::FeatureSetCommon$getCol()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getFeature"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getFeature'><code>retistruct::FeatureSetCommon$getFeature()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getFeatures"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getFeatures'><code>retistruct::FeatureSetCommon$getFeatures()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getIDs"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getIDs'><code>retistruct::FeatureSetCommon$getIDs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="getIndex"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-getIndex'><code>retistruct::FeatureSetCommon$getIndex()</code></a></span></li>
<li><span class="pkg-link" data-pkg="retistruct" data-topic="FeatureSetCommon" data-id="setID"><a href='../../retistruct/html/FeatureSetCommon.html#method-FeatureSetCommon-setID'><code>retistruct::FeatureSetCommon$setID()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CountSet-new"></a>}}
\if{latex}{\out{\hypertarget{method-CountSet-new}{}}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CountSet$new(data = NULL, cols = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{List of matrices describing data. Each matrix
should have columns named \code{X}, \code{Y} and \code{C}}

\item{\code{cols}}{Named vector of colours for each data set. The name is
used as the ID (label) for the data set. The colours should be names
present in the output of the \code{\link{colors}} function}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CountSet-reconstruct"></a>}}
\if{latex}{\out{\hypertarget{method-CountSet-reconstruct}{}}}
\subsection{Method \code{reconstruct()}}{
Map the CountSet to a \code{\link{ReconstructedOutline}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CountSet$reconstruct(ro)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ro}}{The \code{\link{ReconstructedOutline}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CountSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CountSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CountSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
