% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wildcards.R
\name{wildcards}
\alias{maybe}
\alias{one_or_more}
\alias{wildcards}
\alias{zero_or_more}
\alias{zero_or_one}
\title{Wildcards}
\usage{
zero_or_more(..., type = c("greedy", "lazy", "possessive"))

one_or_more(..., type = c("greedy", "lazy", "possessive"))

maybe(..., type = c("greedy", "lazy", "possessive"))
}
\arguments{
\item{...}{\code{\link{shortcuts}}, R variables, text, or other \pkg{rex}
functions.}

\item{type}{the type of match to perform.

There are three match types
\enumerate{
  \item \code{greedy}: match the longest string.  This is the default matching type.
  \item \code{lazy}: match the shortest string.  This matches the shortest string from the same anchor point, not necessarily the shortest global string.
  \item \code{possessive}: match and don't allow backtracking
}}
}
\description{
Wildcards
}
\section{Functions}{
\itemize{
\item \code{zero_or_more}: match \code{...} zero or more times.

\item \code{one_or_more}: match \code{...} one or more times.

\item \code{maybe}: match \code{...} zero or one times.
}}
\seealso{
Other rex: \code{\link{\%or\%}}, \code{\link{capture}},
  \code{\link{character_class}}, \code{\link{counts}},
  \code{\link{group}}, \code{\link{lookarounds}},
  \code{\link{not}}, \code{\link{rex}},
  \code{\link{shortcuts}}
}

