% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_dynamics.R
\name{length_weight}
\alias{length_weight}
\alias{poplw}
\title{length_weight}
\usage{
length_weight(
  species_list = NULL,
  fields = NULL,
  server = getOption("FISHBASE_API", "fishbase"),
  version = get_latest_release(),
  db = default_db(),
  ...
)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned.  Mostly for backwards compatibility as users can subset by column later}

\item{server}{can be set to either "fishbase" or "sealifebase" to switch between databases. NOTE: it is usually
easier to leave this as NULL and set the source instead using the environmental variable `FISHBASE_API`, e.g.
`Sys.setenv(FISHBASE_API="sealifebase")`.}

\item{version}{a version string for the database, will default to the latest release. see [get_releases()] for details.}

\item{db}{the}

\item{...}{unused; for backwards compatibility only}
}
\value{
a table of length_weight information by species; see details
}
\description{
The LENGTH-WEIGHT table presents the a and b values of over 5,000
length-weight relationships of the form W = a x Lb, pertaining to about over 2,000 fish species.
}
\details{
See references for official documentation.  From FishBase.org:
Length-weight relationships are important in fisheries science, 
notably to raise length-frequency samples to total catch, or to
estimate biomass from underwater length observations. 
The units of length and weight in FishBase are centimeter and gram, respectively. 
Thus when length-weight relationships are not in cm-g, the intercept 'a' 
is transformed as follows:

a'(cm, g) = a (mm, g)*10^b
a'(cm, g) = a (cm, kg)*1000
a'(cm, g) = a (mm, mg)*10^b/1000
a'(cm, g) = a (mm, kg)*10^b*1000

However, published length-weight relationships are sometimes difficult to use,
as they may be based on a length measurement type (e.g., fork length) different
from ones length measurements (expressed e.g., as total length).
Therefore, to facilitate conversion between length types, an additional
LENGTH-LENGTH table, #' presented below, was devised which presents linear
regressions or ratios linking length types (e.g., FL vs. TL). 
We included a calculated field with the weight of a 10 cm fish (which
should be in the order of 10 g for normal, fusiform shaped fish),
to allow identification of gross errors, given knowledge of the body
form of a species.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
 \dontrun{
length_weight("Oreochromis niloticus")
}
\dontshow{\}) # examplesIf}
}
\references{
http://www.fishbase.org/manual/english/fishbasethe_length_weight_table.htm
}
