% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synonyms.R
\name{validate_names}
\alias{validate_names}
\title{validate_names}
\usage{
validate_names(
  species_list,
  server = getOption("FISHBASE_API", "fishbase"),
  version = get_latest_release(),
  db = default_db(),
  ...
)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{server}{Either "fishbase" or "sealifebase".}

\item{version}{a version string for the database. See \code{\link[=available_releases]{available_releases()}} for details.}

\item{db}{database connection, now deprecated.}

\item{...}{additional arguments, currently ignored}
}
\value{
a string of the validated names
}
\description{
Check for alternate versions of a scientific name and return
the scientific names FishBase recognizes as valid
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

  \donttest{
validate_names("Abramites ternetzi")
}
\dontshow{\}) # examplesIf}
}
