% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flsgen_extract_structure_from_raster.R
\name{flsgen_extract_structure_from_raster}
\alias{flsgen_extract_structure_from_raster}
\title{Extracts a landscape structure from an existing raster}
\usage{
flsgen_extract_structure_from_raster(
  raster_file,
  focal_classes,
  connectivity = 4
)
}
\arguments{
\item{raster_file}{raster object or path of the raster}

\item{focal_classes}{vector of integers representing the raster values of
the focal classes to extract the structure from}

\item{connectivity}{Connectivity definition in the regular square grid (4 or 8)."}
}
\value{
A JSON landscape structure that can be used with flsgen generate
}
\description{
Extracts a landscape structure from an existing raster
}
\examples{
  \dontrun{
    ls_struct <- flsgen_extract_structure_from_raster(raster_path, c(0, 1, 2))
  }

}
