% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_queue.R
\docType{data}
\name{GbifQueue}
\alias{GbifQueue}
\title{GBIF download queue}
\arguments{
\item{...}{any number of \code{\link[=occ_download]{occ_download()}} requests}

\item{.list}{any number of \code{\link[=occ_download]{occ_download()}} requests as \code{lazy}
objects, called with e.g., \code{lazyeval::lazy()}}
}
\description{
GBIF download queue
}
\details{
\strong{Methods}
\describe{
\item{\code{add(x)}}{
Add single jobs to the queue
}
\item{\code{add_all()}}{
Add all jobs to the queue
}
\item{\code{remove(x)}}{
Remove a job from the queue
}
\item{\code{jobs()}}{
Give number of jobs in the \code{queue}
}
\item{\code{next_()}}{
Get the next job in the \code{queue}. if no more jobs, returns
empty list
}
\item{\code{last_()}}{
Get the last job in the \code{queue}. if no more jobs, returns
empty list
}
}
}
\examples{
\dontrun{
x <- GbifQueue$new(
  occ_download('taxonKey = 3119195', "year = 1976"),
  occ_download('taxonKey = 3119195', "year = 2001"),
  occ_download('taxonKey = 3119195', "year = 2001", "month <= 8"),
  occ_download('taxonKey = 3119195', "year = 2004"),
  occ_download('taxonKey = 3119195', "year = 2005")
)
que = x
x
x$reqs
x$add_all()
x$jobs()
x
x$remove(x$reqs[[1]])
x

# pre-prepared download request
z <- occ_download_prep(
  "basisOfRecord = HUMAN_OBSERVATION,OBSERVATION",
  "hasCoordinate = true",
  "hasGeospatialIssue = false",
  "year = 1993",
  user = "foo", pwd = "bar", email = "foo@bar.com"
)
out <- GbifQueue$new(.list = list(z))
out
out$reqs
}
}
\keyword{internal}
