% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account.R
\name{account}
\alias{account}
\title{Get Account Details For An Account}
\usage{
account(acct_id, api.key, secret, passphrase)
}
\arguments{
\item{acct_id}{Mandatory character value. This is case senstivite. Must be one of the \code{id} generated from \code{\link{accounts}}}

\item{api.key}{Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.}

\item{secret}{Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.}

\item{passphrase}{Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.}
}
\value{
Dataframe with a single row, provides the currency, the current balance, available, holds and profile_id of the user.
}
\description{
This is an auth based function. User must have valid api keys generated by GADX which must be passed as mandatory arguments. The function takes an account id as an additional input and returns the account details for that account. The account details currently include information about the currency (fiat or crypto) and the details on the balance (total, available and help for other transactions).
}
\examples{
\dontrun{
account(acct_id = "9kb58e27-276s-4g99-r2v7-128723948k1c",
       api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
}

}
