% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_utils.R
\name{ee_utils_shp_to_zip}
\alias{ee_utils_shp_to_zip}
\title{Create a zip file from a sf object}
\usage{
ee_utils_shp_to_zip(
  x,
  filename,
  SHP_EXTENSIONS = c("dbf", "prj", "shp", "shx")
)
}
\arguments{
\item{x}{sf object}

\item{filename}{data source name}

\item{SHP_EXTENSIONS}{file extension of the files to save
into the zip file. By default: "dbf", "prj", "shp", "shx".}
}
\value{
Character. The full path of the zip file created.
}
\description{
Create a zip file from a sf object
}
\examples{
\dontrun{
library(rgee)
library(sf)
ee_Initialize(gcs = TRUE)

# Create sf object
nc <- st_read(system.file("shape/nc.shp", package="sf"))
zipfile <- ee_utils_shp_to_zip(nc)
}
}
\seealso{
Other ee_utils functions: 
\code{\link{ee_utils_py_to_r}()},
\code{\link{ee_utils_pyfunc}()}
}
\concept{ee_utils functions}
