% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_file6.R
\name{read_file6}
\alias{read_file6}
\title{Read files of 'graph6', 'sparse6' or 'digraph6' symbols}
\usage{
read_file6(path, type = "adjacency")
}
\arguments{
\item{path}{character; path to file name}

\item{type}{character; one of "adjacency", "edgelist", "igraph", or
"network". Type of result returned.}
}
\value{
A list of decoded graphs in the form of objects determined by \code{type}.
}
\description{
Read files of 'graph6', 'sparse6' or 'digraph6' symbols
}
\details{
File pointed to by \code{path} is a text file with one graph symbol per line.
Optional headers of the form \verb{>>graph6<<} or \verb{>>sparse6<<} in the first
line (and without the newline after the header) are ignored and removed.
}
\examples{
g6_file <- tempfile()
write(sampleg6,g6_file)
read_file6(g6_file, type = "adjacency")
unlink(g6_file)
}
