% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-cluster.R
\name{Birch}
\alias{Birch}
\title{Performs clustering according to the Birch algorithm}
\description{
It is a memory-efficient, online-learning algorithm provided as an
alternative to \link{MiniBatchKMeans}. It constructs a tree data structure with
the cluster centroids being read off the leaf. These can be either the final
cluster centroids or can be provided as input to another clustering algorithm
such as \link{AgglomerativeClustering}. This is a wrapper around the Python class
\href{https://scikit-learn.org/stable/modules/generated/sklearn.cluster.Birch.html#sklearn.cluster.Birch}{sklearn.cluster.Birch}.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.cluster")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cl <- Birch$new()
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Tian Zhang, Raghu Ramakrishnan, Maron Livny (1996). \emph{BIRCH: An efficient
data clustering method for large databases},
\url{https://www.cs.sfu.ca/CourseCentral/459/han/papers/zhang96.pdf}.
\item Roberto Perdisci J. \emph{Birch - Java implementation of BIRCH clustering
algorithm}, \url{https://code.google.com/archive/p/jbirch}.
}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseClustering]{rgudhi::BaseClustering}} -> \code{Birch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Birch-new}{\code{Birch$new()}}
\item \href{#method-Birch-clone}{\code{Birch$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Birch-new"></a>}}
\if{latex}{\out{\hypertarget{method-Birch-new}{}}}
\subsection{Method \code{new()}}{
The \link{Birch} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Birch$new(
  threshold = 0.5,
  branching_factor = 50L,
  n_clusters = 3L,
  compute_labels = TRUE,
  copy = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{A numeric value specifying the upper bound of the radius
of the subcluster obtained by merging a new sample and the closest
subcluster. Otherwise a new subcluster is started. Setting this value
to be very low promotes splitting and vice-versa. Defaults to \code{0.5}.}

\item{\code{branching_factor}}{An integer value specifying the maximum number of
CF subclusters in each node. If a new sample enters such that the
number of subclusters exceeds the \code{branching_factor} then that node is
splitted into two nodes with the subclusters redistributed in each. The
parent subcluster of that node is removed and two new subclusters are
added as parents of the 2 split nodes.}

\item{\code{n_clusters}}{Either an integer value or an object of class
\link{BaseClustering} specifying the number of clusters after the final
clustering step, which treats the subclusters from the leaves as new
samples.
\itemize{
\item \code{NULL}: the final clustering step is not performed and the
subclusters are returned as they are;
\item an object of class \link{BaseClustering}: the model is fit treating
the subclusters as new samples and the initial data is mapped to the
label of the closest subcluster;
\item integer value: the model fit is \link{AgglomerativeClustering} with
\code{n_clusters} set to be equal to the integer value.
Defaults to \code{3L}.
}}

\item{\code{compute_labels}}{A boolean value specifying whether to compute
labels for each fit. Defaults to \code{TRUE}.}

\item{\code{copy}}{A boolean value specifying whether to make a copy of the
given data. If set to \code{FALSE}, the initial data will be overwritten.
Defaults to \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{Birch}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Birch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Birch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Birch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
