% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-vector-methods.R
\name{Entropy}
\alias{Entropy}
\title{Vector Representation: Entropy}
\description{
Computes persistence entropy. Persistence entropy is a statistic
for persistence diagrams inspired from Shannon entropy. This statistic can
also be used to compute a feature vector, called the entropy summary
function. See https://arxiv.org/pdf/1803.08304.pdf for more details. Note
that a previous implementation was contributed by Manuel Soriano-Trigueros.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
ent <- Entropy$new()
ent$apply(dgm)
ent$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:VectorRepresentationStep]{rgudhi::VectorRepresentationStep}} -> \code{Entropy}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Entropy-new}{\code{Entropy$new()}}
\item \href{#method-Entropy-clone}{\code{Entropy$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="apply"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-apply'><code>rgudhi::VectorRepresentationStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit'><code>rgudhi::VectorRepresentationStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit_transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit_transform'><code>rgudhi::VectorRepresentationStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-transform'><code>rgudhi::VectorRepresentationStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Entropy-new"></a>}}
\if{latex}{\out{\hypertarget{method-Entropy-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{Entropy}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Entropy$new(
  mode = c("scalar", "vector"),
  normalized = TRUE,
  resolution = 100,
  sample_range = rep(NA_real_, 2)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{A string specifying which entropy to compute: either
\code{"scalar"} for computing the entropy statistic, or \code{"vector"} for
computing the entropy summary function. Defaults to \code{"scalar"}.}

\item{\code{normalized}}{A boolean value specifying whether to normalize the
entropy summary function. Defaults to \code{TRUE}. Used only if \code{mode == "vector"}.}

\item{\code{resolution}}{An integer value specifying the grid size for the
entropy summary function. Defaults to \code{100L}. Used only if \code{mode == "vector"}.}

\item{\code{sample_range}}{A length-2 numeric vector specifying the domain for
the entropy summary function, of the form \eqn{[x_{\min}, x_{\max}]}.
Defaults to \code{rep(NA, 2)}. It is the interval on which samples will be
drawn evenly. If one of the values is \code{NA}, it can be computed from the
persistence diagrams with the \verb{$fit()} method. Used only if \code{mode == "vector"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{Entropy}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Entropy-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Entropy-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Entropy$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
