% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex-witness.R
\name{WitnessComplex}
\alias{WitnessComplex}
\title{R6 Class for Witness Complex}
\description{
A Witness complex \eqn{\mathrm{Wit}(W,L)} is a simplicial
complex defined on two sets of points in \eqn{R^D}. The data structure is
described in \insertCite{boissonnat2014simplex;textual}{rgudhi}.
}
\details{
The class constructs a (weak) witness complex for a given table of
nearest landmarks with respect to witnesses.
\subsection{References}{

\insertCited{}
}
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
withr::with_seed(1234, {
  l <- list(
    tibble::tibble(
      nearest_landmark = sample.int(10),
      distance = sort(rexp(10))
    ),
    tibble::tibble(
      nearest_landmark = sample.int(10),
      distance = sort(rexp(10))
    )
  )
})
wc <- WitnessComplex$new(nearest_landmark_table = l)
wc
\dontshow{\}) # examplesIf}
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
withr::with_seed(1234, {
  l <- list(
    tibble::tibble(
      nearest_landmark = sample.int(10),
      distance = sort(rexp(10))
    ),
    tibble::tibble(
      nearest_landmark = sample.int(10),
      distance = sort(rexp(10))
    )
  )
})
wc <- WitnessComplex$new(nearest_landmark_table = l)
st <- wc$create_simplex_tree()
st$num_vertices()
\dontshow{\}) # examplesIf}
}
\seealso{
Other filtrations and reconstructions: 
\code{\link{AlphaComplex}},
\code{\link{RipsComplex}},
\code{\link{TangentialComplex}}
}
\author{
Siargey Kachanovich
}
\concept{filtrations and reconstructions}
\section{Super class}{
\code{rgudhi::PythonClass} -> \code{WitnessComplex}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WitnessComplex-new}{\code{WitnessComplex$new()}}
\item \href{#method-WitnessComplex-create_simplex_tree}{\code{WitnessComplex$create_simplex_tree()}}
\item \href{#method-WitnessComplex-clone}{\code{WitnessComplex$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WitnessComplex-new"></a>}}
\if{latex}{\out{\hypertarget{method-WitnessComplex-new}{}}}
\subsection{Method \code{new()}}{
The \link{WitnessComplex} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WitnessComplex$new(nearest_landmark_table)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nearest_landmark_table}}{A list of \link[tibble:tibble]{tibble::tibble}s
specifying for each \emph{witness} \code{w}, the ordered list of nearest
landmarks with id in column \code{nearest_landmark} and distance to \code{w} in
column \code{distance}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{WitnessComplex}} object storing the Witness
complex.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WitnessComplex-create_simplex_tree"></a>}}
\if{latex}{\out{\hypertarget{method-WitnessComplex-create_simplex_tree}{}}}
\subsection{Method \code{create_simplex_tree()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WitnessComplex$create_simplex_tree(max_alpha_square = Inf)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max_alpha_square}}{The maximum relaxation parameter. Defaults to
\code{Inf}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{SimplexTree}} object storing the computed simplex
tree created from the Delaunay triangulation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WitnessComplex-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WitnessComplex-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WitnessComplex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
