test_that("Class `SimplexTree` works", {
  n <- 10
  X <- seq_circle(n)
  st <- SimplexTree$new()
  rc <- RipsComplex$new(data = X, max_edge_length = 1)
  st <- rc$create_simplex_tree(max_dimension = 2)
  st$compute_persistence()
  expect_snapshot(st$filtration(1:2))
  expect_equal(st$filtration(1), 0)
  st$assign_filtration(1, 0.8)
  st$compute_persistence()
  expect_equal(st$filtration(1), 0.8)
  expect_true(all(st$betti_numbers() == c(1, 1)))
  st$collapse_edges()
  st$compute_persistence()
  expect_equal(st$dimension(), 1)
  st$expansion(2)
  st$compute_persistence()
  st$extend_filtration()
  st$compute_persistence()
  expect_snapshot(st$extended_persistence())
  expect_true(st$find(1:2))
  expect_snapshot(st$flag_persistence_generators())
  expect_snapshot(st$get_boundaries(1:2))
  expect_equal(st$get_star(1:2), st$get_cofaces(1:2, 0))
  expect_snapshot(st$get_filtration())
  expect_snapshot(st$get_simplices())
  expect_snapshot(st$get_skeleton(0))
  st$insert(1:2)
  st$compute_persistence()
  expect_true(st$insert(1:3, chainable = FALSE))
  st$compute_persistence()
  expect_snapshot(st$lower_star_persistence_generators())
  st$make_filtration_non_decreasing()
  expect_equal(st$num_simplices(), 43)
  expect_equal(st$num_vertices(), 11)
  expect_snapshot(st$persistence())
  st$compute_persistence()
  expect_snapshot(st$persistence_intervals_in_dimension(0))
  expect_snapshot(st$persistence_pairs())
  expect_equal(st$persistent_betti_numbers(0, 0.5), c(2, 1))
  st$prune_above_filtration(0.12)
  st$compute_persistence()
  st$remove_maximal_simplex(1:2)
  st$compute_persistence()
  st$reset_filtration(0.1)
  st$compute_persistence()
  st$set_dimension(1)
  st$compute_persistence()
  expect_equal(st$upper_bound_dimension(), 1)
})
