% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{build_sass}
\alias{build_sass}
\title{Build Sass}
\usage{
build_sass(watch = FALSE)
}
\arguments{
\item{watch}{Keep the process running and rebuilding Sass whenever source files change.
Only supported for \code{sass: node} configuration in \code{rhino.yml}.}
}
\value{
None. This function is called for side effects.
}
\description{
Builds the \code{app/styles/main.scss} file into \code{app/static/css/app.min.css}.
}
\details{
The build method can be configured using the \code{sass} option in \code{rhino.yml}:
\enumerate{
\item \code{node}: Use \href{https://sass-lang.com/dart-sass}{Dart Sass}
(requires Node.js to be available on the system).
\item \code{r}: Use the \code{{sass}} R package.
}

It is recommended to use Dart Sass which is the primary,
actively developed implementation of Sass.
On systems without Node.js you can use the \code{{sass}} R package as a fallback.
It is not advised however, as it uses the deprecated
\href{https://sass-lang.com/blog/libsass-is-deprecated}{LibSass} implementation.
}
\examples{
if (interactive()) {
  # Build the `app/styles/main.scss` file into `app/static/css/app.min.css`.
  build_sass()
}
}
