% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccardIndex.R
\name{columnOverlapCoefficient}
\alias{columnOverlapCoefficient}
\title{Pairwise jaccard/overlap coefficient can be calculated efficiently using matrix
Pairwise overlap coefficient of binary matrix by column}
\usage{
columnOverlapCoefficient(x, y = NULL)
}
\arguments{
\item{x}{An integer matrix, other objects will be coereced into a matrix}

\item{y}{An integer matrix, other objects will be coereced into a matrix. In case of 
\code{NULL}, pairwise overlap coefficients by column of \code{x} is returned.}
}
\value{
A matrix of column-wise pairwise overlap coefficients of the binary matrix. \code{NaN} 
is reported when neither of the columns have any non-zero element.
}
\description{
Pairwise jaccard/overlap coefficient can be calculated efficiently using matrix
Pairwise overlap coefficient of binary matrix by column
}
\examples{

set.seed(1887)
testMatrix1 <- matrix(rbinom(120, 1, 0.2), nrow=15)
columnOverlapCoefficient(testMatrix1)

testMatrix2 <- matrix(rbinom(150, 1, 0.2), nrow=15)
testMatrix12Poe <- columnOverlapCoefficient(testMatrix1, 
  testMatrix2)

}
