% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim}
\alias{trim}
\title{Trim leading and tailing spaces from string}
\usage{
trim(x, left = " \\n\\r\\t", right = " \\n\\r\\t")
}
\arguments{
\item{x}{A character string, or a vector of strings}

\item{left}{Characters that are trimmed from the left side.}

\item{right}{Characters that are trimmed from the right side}
}
\value{
Trimmed string(s)
}
\description{
The function trims leading and/or tailing spaces from string(s), using C
function implemented in the BIOS library.
}
\details{
\code{left} and \code{right} can be set to NULL. In such cases no trimming
will be performed.
}
\examples{

myStrings <- c("This is a fine day\n",
               " Hallo Professor!",
               "  NUR DER HSV  ")
trim(myStrings)

}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
