% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback-sep3.R
\name{susp_inf}
\alias{susp_inf}
\title{Suspicion of infection label}
\usage{
susp_inf(
  ...,
  abx_count_win = hours(24L),
  abx_min_count = 1L,
  positive_cultures = FALSE,
  si_mode = c("and", "or", "abx", "samp"),
  abx_win = hours(24L),
  samp_win = hours(72L),
  by_ref = TRUE,
  keep_components = FALSE,
  interval = NULL
)
}
\arguments{
\item{...}{Data and further arguments are passed to \code{si_calc()}}

\item{abx_count_win}{Time span during which to apply the \code{abx_min_count}
criterion}

\item{abx_min_count}{Minimal number of antibiotic administrations}

\item{positive_cultures}{Logical flag indicating whether to require
cultures to be positive}

\item{si_mode}{Switch between \code{and}, \code{or}, \code{abx}, \code{samp} modes}

\item{abx_win}{Time-span within which sampling has to occur}

\item{samp_win}{Time-span within which antibiotic administration has to
occur}

\item{by_ref}{Logical flag indicating whether to process data by reference}

\item{keep_components}{Logical flag indicating whether to return the
individual components alongside the aggregated score}

\item{interval}{Time series interval (only used for checking consistency
of input data)}
}
\description{
Suspected infection is defined as co-occurrence of of antibiotic treatment
and body-fluid sampling.
}
\details{
Suspected infection can occur in one of the two following ways:
\itemize{
\item administration of antibiotics followed by a culture sampling within
\code{samp_win} hours\preformatted{       abx_win
   |---------------|
  ABX           sampling (last possible)
}
\item culture sampling followed by an antibiotic administration within
\code{abx_win} hours\preformatted{                     samp_win
   |---------------------------------------------|
sampling                                        ABX (last possible)
}
}

The default values of \code{samp_win} and \code{abx_win} are 24 and 72 hours
respectively, as per \href{https://jamanetwork.com/journals/jama/fullarticle/2492881}{Singer et.al. }.

The earlier of the two times (fluid sampling, antibiotic treatment) is taken
as the time of suspected infection (SI time). The suspected infection
window (SI window) is defined to start \code{si_lwr} hours before the SI time
and end \code{si_upr} hours after the SI time. The default values of 48 and 24
hours (respectively) are chosen as used by \href{https://jamanetwork.com/journals/jama/fullarticle/2492875}{Seymour et.al. } (see
Supplemental Material).\preformatted{                48h                       24h
  |------------------------------(|)---------------|
                                SI time
}

For some datasets, however, information on body fluid sampling is not
available for majority of the patients (eICU data). Therefore, an
alternative definition of suspected infection is required. For this, we use
administration of multiple antibiotics (argument \code{abx_min_count} determines
the required number) within \code{abx_count_win} hours. The first time of
antibiotic administration is taken as the SI time in this case.
}
\references{
Singer M, Deutschman CS, Seymour CW, et al. The Third International
Consensus Definitions for Sepsis and Septic Shock (Sepsis-3). JAMA.
2016;315(8):801–810. doi:10.1001/jama.2016.0287

Seymour CW, Liu VX, Iwashyna TJ, et al. Assessment of Clinical Criteria for
Sepsis: For the Third International Consensus Definitions for Sepsis and
Septic Shock (Sepsis-3). JAMA. 2016;315(8):762–774.
doi:10.1001/jama.2016.0288
}
