% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PHom.R
\name{PHom}
\alias{PHom}
\title{Persistence Data Container}
\usage{
PHom(x, dim_col = 1, birth_col = 2, death_col = 3)
}
\arguments{
\item{x}{object used to create \code{PHom} instance}

\item{dim_col}{either \code{integer} representing column index for feature
dimension data or \code{character} representing column name}

\item{birth_col}{either \code{integer} representing column index for feature
birth data or \code{character} representing column name}

\item{death_col}{either \code{integer} representing column index for feature
death data or \code{character} representing column name}
}
\value{
\code{PHom} instance
}
\description{
PHom() creates instances of \code{PHom} objects, which are convenient containers
for persistence data. Generally, data frame (or similar) objects are used
to create \code{PHom} instances with users specifying which columns contain
dimension, birth, and death details for each feature.
}
\examples{
# construct data frame with valid persistence data
df <- data.frame(dimension = c(0, 0, 1, 1, 1, 2),
                 birth = rnorm(6),
                 death = rnorm(6, mean = 15))

# create `PHom` instance and print
df_phom <- PHom(df)
df_phom

# print feature details to confirm accuracy
print.data.frame(df_phom)
}
