% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vietoris_rips.R
\name{vietoris_rips}
\alias{vietoris_rips}
\alias{vietoris_rips.data.frame}
\alias{vietoris_rips.matrix}
\alias{vietoris_rips.dist}
\alias{vietoris_rips.numeric}
\alias{vietoris_rips.ts}
\alias{vietoris_rips.default}
\title{Calculate Persistent Homology via a Vietoris-Rips Complex}
\usage{
vietoris_rips(dataset, ...)

\method{vietoris_rips}{data.frame}(dataset, ...)

\method{vietoris_rips}{matrix}(dataset, max_dim = 1L, threshold = -1, p = 2L, dim = NULL, ...)

\method{vietoris_rips}{dist}(dataset, max_dim = 1L, threshold = -1, p = 2L, dim = NULL, ...)

\method{vietoris_rips}{numeric}(
  dataset,
  data_dim = 2L,
  dim_lag = 1L,
  sample_lag = 1L,
  method = "qa",
  ...
)

\method{vietoris_rips}{ts}(dataset, ...)

\method{vietoris_rips}{default}(dataset, ...)
}
\arguments{
\item{dataset}{object on which to calculate persistent homology}

\item{...}{other relevant parameters}

\item{max_dim}{maximum dimension of persistent homology features to be
calculated}

\item{threshold}{maximum simplicial complex diameter to explore}

\item{p}{prime field in which to calculate persistent homology}

\item{dim}{deprecated; passed to \code{max_dim} or ignored if \code{max_dim} is
specified}

\item{data_dim}{desired end data dimension}

\item{dim_lag}{time series lag factor between dimensions}

\item{sample_lag}{time series lag factor between samples (rows)}

\item{method}{currently only allows \code{"qa"} (quasi-attractor method)}
}
\value{
\code{PHom} object
}
\description{
This function is an R wrapper for the Ripser C++ library to calculate
persistent homology. For more information on the C++ library, see
\url{https://github.com/Ripser/ripser}. For more information on how objects of
different classes are evaluated by \code{vietoris_rips}, read the Details section
below.
}
\details{
\code{vietoris_rips.data.frame} assumes \code{dataset} is a point cloud, with each row
representing a point and each column representing a dimension.

\code{vietoris_rips.matrix} currently assumes \code{dataset} is a point cloud (similar
to \code{vietoris_rips.data.frame}). Currently in the process of adding network
representation to this method.

\code{vietoris_rips.dist} takes a \code{dist} object and calculates persistent homology
based on pairwise distances. The \code{dist} object could have been calculated
from a point cloud, network, or any object containing elements from a finite
metric space.

\code{vietoris_rips.numeric} and \code{vietoris_rips.ts} both calculate persistent
homology of a time series object. The time series object is converted to a
matrix using the quasi-attractor method detailed in Umeda (2017)
\url{doi:10.1527/tjsai.D-G72}. Persistent homology of the resulting matrix is
then calculated.
}
\examples{

# create a 2-d point cloud of a circle (100 points)
num.pts <- 100
rand.angle <- runif(num.pts, 0, 2*pi)
pt.cloud <- cbind(cos(rand.angle), sin(rand.angle))

# calculate persistent homology (num.pts by 3 numeric matrix)
pers.hom <- vietoris_rips(pt.cloud)
}
