% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoxInfo.R
\name{CoxVarCov}
\alias{CoxVarCov}
\alias{CoxVarCov.cph}
\alias{CoxVarCov.coxph}
\alias{CoxVarCov.phreg}
\title{Extract the variance covariance matrix of the beta from a Cox model}
\usage{
CoxVarCov(object)

\method{CoxVarCov}{cph}(object)

\method{CoxVarCov}{coxph}(object)

\method{CoxVarCov}{phreg}(object)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}
}
\description{
Extract the variance covariance matrix of the beta from a Cox model
}
\details{
Should return \code{NULL} if the Cox model has no covariate. 
The rows and columns of the variance covariance matrix must be named with the names used in the design matrix.
}
\examples{
\dontrun{
d <- sampleData(1e2, outcome = "survival")
d$entry <- 0

##
library(survival)
mCox <- coxph(Surv(time, event) ~ X1+X2, data = d)
CoxVarCov(mCox)
mCox <- coxph(Surv(time, event) ~ 1, data = d, y = TRUE)
CoxVarCov(mCox)

##
library(rms)
mCox <- cph(Surv(time, event) ~ X1+X2, data = d, y = TRUE)
CoxVarCov(mCox)
mCox <- cph(Surv(time, event) ~ 1, data = d, y = TRUE)
CoxVarCov(mCox)

##
library(mets)
mCox <- phreg(Surv(entry, time, event) ~ X1+X2, data = d)
CoxVarCov(mCox)
mCox <- cph(Surv(time, event) ~ 1, data = d, y = TRUE)
CoxVarCov(mCox)
}
}
\author{
Brice Ozenne broz@sund.ku.dk
}
