% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influenceTest.R
\name{influenceCoxTest}
\alias{influenceCoxTest}
\alias{influenceCoxTest.list}
\alias{influenceCoxTest.default}
\title{Influence test [Experimental!!]}
\usage{
influenceCoxTest(object, ...)

\method{influenceCoxTest}{list}(object, newdata, times, type, cause, ...)

\method{influenceCoxTest}{default}(object, object2, tanh.transform = FALSE,
  conf.level = 0.95, nsim.band = 10000, ...)
}
\arguments{
\item{object}{either a list of models or an object of class predictCox or predictCSC.}

\item{...}{additional arguments to be passed to lower level functions.}

\item{newdata}{A \code{data.frame} or \code{data.table} containing
the values of the predictor variables defining subject specific
predictions.}

\item{times}{Time points at which to evaluate the predictions.}

\item{type}{the type of predicted value.}

\item{cause}{Identifies the cause of interest among the competing
events.}

\item{object2}{same as predict1 but for another model.}

\item{tanh.transform}{Should the comparison be made on the arc-tangent scale or on the original scale ?}

\item{conf.level}{Level of confidence.}

\item{nsim.band}{the number of simulations used to compute the quantiles
for the confidence bands.}
}
\description{
Compare two estimates using their influence function
}
\examples{
library(lava)
library(survival)
n <- 100

#### Under H1
set.seed(1)
newdata <- data.frame(X1=1)

## simulate non proportional hazard using lava
m <- lvm()
regression(m) <- y ~ 1
regression(m) <- s ~ exp(-2*X1)
distribution(m,~X1) <- binomial.lvm()
distribution(m,~cens) <- coxWeibull.lvm(scale=1)
distribution(m,~y) <- coxWeibull.lvm(scale=1,shape=~s)
eventTime(m) <- eventtime ~ min(y=1,cens=0)
d <- as.data.table(sim(m,n))
setkey(d, eventtime)

## fit cox models
m.cox <- coxph(Surv(eventtime, status) ~ X1, 
               data = d, y = TRUE, x = TRUE)

mStrata.cox <- coxph(Surv(eventtime, status) ~ strata(X1), 
                     data = d, y = TRUE, x = TRUE)

## compare models
# one time point
influenceCoxTest(list(m.cox, mStrata.cox), tanh.transform = FALSE,
                 type = "survival", newdata = newdata, times = 0.5)
influenceCoxTest(list(m.cox, mStrata.cox), tanh.transform = TRUE,
                 type = "survival", newdata = newdata, times = 0.5)
                                 
# several timepoints
influenceCoxTest(list(m.cox, mStrata.cox), tanh.transform = TRUE,
                 type = "survival", newdata = newdata, times = seq(0.1,1,by=0.1))
influenceCoxTest(list(m.cox, mStrata.cox), tanh.transform = FALSE,
                 type = "survival", newdata = newdata, times = seq(0.1,1,by=0.1))

#### Under H0 (Cox) ####
set.seed(1)
## simulate proportional hazard using lava
m <- lvm()
regression(m) <- y ~ 1
distribution(m,~X1) <- binomial.lvm()
distribution(m,~cens) <- coxWeibull.lvm()
distribution(m,~y) <- coxWeibull.lvm()
eventTime(m) <- eventtime ~ min(y=1,cens=0)
d <- as.data.table(sim(m,n))
setkey(d, eventtime)

## fit cox models
Utime <- sort(unique(d$eventtime))
m.cox <- coxph(Surv(eventtime, status) ~ X1, 
               data = d, y = TRUE, x = TRUE)

mStrata.cox <- coxph(Surv(eventtime, status) ~ strata(X1), 
                     data = d, y = TRUE, x = TRUE)

p.cox <- predictCox(m.cox, newdata = newdata, time = Utime, type = "survival")
p.coxStrata <- predictCox(mStrata.cox, newdata = newdata, time = Utime, type = "survival")
autoplot(p.cox)
autoplot(p.coxStrata)
 
## compare models
influenceCoxTest(list(m.cox, mStrata.cox), tanh.transform = TRUE,
                 type = "survival", newdata = newdata, times = Utime[1:(n-10)])
influenceCoxTest(list(m.cox, mStrata.cox), tanh.transform = FALSE,
                 type = "survival", newdata = newdata, times = Utime[1:(n-10)])

#### Under H0 (CSC) ####
set.seed(1)
ff <- ~ f(X1,2) + f(X2,-0.033)
ff <- update(ff, ~ .+ f(X3,0) + f(X4,0) + f(X5,0))
ff <- update(ff, ~ .+ f(X6,0) + f(X7,0) + f(X8,0) + f(X9,0))
d <- sampleData(n, outcome = "competing.risk", formula = ff)
d[,X1:=as.numeric(as.character(X1))]
d[,X2:=as.numeric(as.character(X2))]
d[,X3:=as.numeric(as.character(X3))]
d[,X4:=as.numeric(as.character(X4))]
d[,X5:=as.numeric(as.character(X5))]
setkey(d, time)

Utime <- sort(unique(d$time))

## fit cox models
m.CSC <- CSC(Hist(time, event) ~ X1 + X2, data = d)
mStrata.CSC <- CSC(Hist(time, event) ~ strata(X1) + X2 + X3, data = d)

## compare models
influenceCoxTest(list(m.CSC, mStrata.CSC), tanh.transform = TRUE,
                 cause = 1, newdata = data.frame(X1=1,X2=1,X3=1), times = Utime[1:20])
influenceCoxTest(list(m.CSC, mStrata.CSC), tanh.transform = FALSE,
                 cause = 1, newdata = data.frame(X1=1,X2=1,X3=1), times = Utime[1:20]) 

}
