% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_metrics_internal}
\alias{get_metrics_internal}
\title{Get Model Metrics for a Single Threshold}
\usage{
get_metrics_internal(
  mod,
  X = NULL,
  y = NULL,
  weights = NULL,
  threshold = 0.5,
  threshold_type = c("response", "score")
)
}
\arguments{
\item{mod}{An object of class \code{risk_mod}, usually a result of a call to
\code{\link[=risk_mod]{risk_mod()}}.}

\item{X}{Input covariate matrix with dimension \eqn{n \times p};
every row is an observation.}

\item{y}{Numeric vector for the (binomial) response variable.}

\item{weights}{Numeric vector of length \eqn{n} with weights for each
observation. Unless otherwise specified, default will give equal weight to
each observation.}

\item{threshold}{Numeric vector of classification threshold values used to
calculate the accuracy, sensitivity, and specificity of the model. Defaults
to a range of risk probability thresholds from 0.1 to 0.9 by 0.1.}

\item{threshold_type}{Defines whether the \code{threshold} vector contains
risk probability values ("response") or threshold values expressed as scores
from the risk score model ("score"). Default: "response".}
}
\value{
List with deviance (dev), accuracy (acc), sensitivity (sens),
specificity (spec), and auc.
}
\description{
Calculates a risk model's deviance, accuracy, sensitivity, and specificity
given a set of data and a threshold value.
}
