% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mosaic.R
\name{plot_mosaic}
\alias{plot_mosaic}
\title{Plot a mosaic plot of population frequencies.}
\usage{
plot_mosaic(prev = num$prev, sens = num$sens, mirt = NA,
  spec = num$spec, fart = NA, N = num$N, by = "cddc",
  show_accu = TRUE, w_acc = 0.5, title_lbl = txt$scen_lbl,
  col_sdt = c(pal["hi"], pal["mi"], pal["fa"], pal["cr"]))
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}.}

\item{sens}{The decision's sensitivity \code{\link{sens}}.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}.}

\item{spec}{The decision's specificity value \code{\link{spec}}.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}.}

\item{N}{The number of individuals in the population.}

\item{by}{A character code specifying the perspective (or categories by which the population is split into subsets) with 3 options:
\enumerate{
\item \code{"cddc"} ... by condition x decision;
\item \code{"dccd"} ... by decision x condition;
\item \code{"cdac"} ... by condition x accuracy.
}}

\item{show_accu}{Option for showing current and exact
accuracy metrics \code{\link{accu}} in the plot.}

\item{w_acc}{Weighting parameter \code{w} used to compute
weighted accuracy.}

\item{title_lbl}{Text label for current plot title.}

\item{col_sdt}{Colors for cases of 4 essential frequencies.
Default: \code{col_sdt = c(pal["hi"], pal["mi"], pal["fa"], pal["cr"])}.}
}
\description{
\code{plot_mosaic} drew a mosaic plot that
represents the proportions of frequencies in the current
population as relatives sizes of rectangular areas.
}
\details{
\code{plot_mosaic} is deprecated -- please use \code{\link{plot_area}} instead.
}
\examples{
plot_mosaic()  # plot with default options

}
\seealso{
\code{\link{plot_area}} is the new version of this function.

Other visualization functions: \code{\link{plot.riskyr}},
  \code{\link{plot_area}}, \code{\link{plot_bar}},
  \code{\link{plot_curve}}, \code{\link{plot_fnet}},
  \code{\link{plot_icons}}, \code{\link{plot_plane}},
  \code{\link{plot_prism}}, \code{\link{plot_tab}},
  \code{\link{plot_tree}}
}
\concept{visualization functions}
