% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskyr_class.R
\name{summary.riskyr}
\alias{summary.riskyr}
\title{Summarize a riskyr scenario.}
\format{An object of class \code{summary.riskyr} with up to 9 entries.}
\usage{
\method{summary}{riskyr}(object = NULL, summarize = "all", ...)
}
\arguments{
\item{object}{An object of class "riskyr", usually a result of a call to \code{\link{riskyr}}.
Inbuilt \code{scenarios} are also of type "riskyr".}

\item{summarize}{What is summarized as a vector consisting of \code{c("freq", "prob", "accu")}
for frequencies, probabilities, and accuracy respectively.
The default "all" is an alias to all three.}

\item{...}{Additional parameters (to be passed to summary functions).}
}
\value{
A summary list \code{obj.sum}
with up to 9 entries, dependent on which information is requested by \code{summarize}.

Scenario name, relevant condition \code{}, and \code{N}
are summarized by default.
}
\description{
\code{summary.riskyr} provides a \code{summary} method for objects of class "riskyr".
}
\examples{
summary(scenarios$n4)

}
\seealso{
\code{\link{riskyr}} initializes a \code{riskyr} scenario.

Other riskyr scenario functions: \code{\link{plot.riskyr}},
  \code{\link{read_popu}}, \code{\link{riskyr}}
}
\concept{riskyr scenario functions}
\concept{summary functions}
