% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credibility.R
\name{credibility}
\alias{credibility}
\alias{credibility_rating}
\alias{credibility_ratings}
\title{Get credibility rating from tsn}
\usage{
credibility_rating(tsn, wt = "json", raw = FALSE, ...)

credibility_ratings(wt = "json", raw = FALSE, ...)
}
\arguments{
\item{tsn}{TSN for a taxonomic group (numeric). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a data.frame
}
\description{
Get credibility rating from tsn
}
\details{
methods:
\itemize{
 \item credibility_rating: Get credibility rating for a tsn
 \item credibility_ratings: Get possible credibility ratings
}
}
\examples{
\dontrun{
credibility_rating(tsn = 526852)
credibility_rating(526852, wt = "xml")
credibility_rating(526852, raw = TRUE)

credibility_ratings()
credibility_ratings(wt = "xml")
credibility_ratings(raw = TRUE)
}
}

