% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_weights_sequencer.R
\name{t_weights_sequencer}
\alias{t_weights_sequencer}
\title{Create the time-dependent weights data}
\usage{
t_weights_sequencer(weights_information, weight = "length", nodes_id = "name")
}
\arguments{
\item{weights_information}{a data.frame that must contain a 'nodes_id' column and several 'weight' columns.
Weight columns are named with the string contained in the 'weight' input and the relative year (4 digits format),
separated by an underscore (e.g. when \code{weight = "length"}, the names of the 'weight' columns will be:
'weight_1990', 'weight_2000', 'weight_2020', etc.).}

\item{weight}{a character object containing the label of the columns whose weight change with time}

\item{nodes_id}{a character object containing the label of the columns that uniquely identify reaches.}
}
\value{
a data frame with columns 'name', 'year', and 'weight' to be used in the function \code{t_index_calculation}
}
\description{
Create the time-dependent weights data
}
\examples{
weights_dataframe <- data.frame("id" = c("1", "2", "3", "4", "5"),
"weight_1900" = c(10, 15, 100, 50, 40),
"weight_1950"= c(11, 16, 90, 55, 45),
"weight_2000"= c(13, 19, 80, 49, 44))
weights_metadata <- t_weights_sequencer(weights_dataframe, weight = "weight", nodes_id = "id")

}
