% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{removeMissingObs}
\alias{removeMissingObs}
\title{Remove cells/genes with no expression across any genes/cells}
\usage{
removeMissingObs(
  object,
  slot.use = "raw.data",
  use.cols = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{liger} object (scale.data or norm.data must be set).}

\item{slot.use}{The data slot to filter (takes "raw.data" and "scale.data") (default "raw.data").}

\item{use.cols}{Treat each column as a cell (default TRUE).}

\item{verbose}{Print messages (TRUE by default)}
}
\value{
\code{liger} object with modified raw.data (or chosen slot) (dataset names preserved).
}
\description{
Removes cells/genes from chosen slot with no expression in any genes or cells respectively.
}
\examples{
\dontrun{
# liger object: ligerex
ligerex <- removeMissingObs(ligerex)
}
}
