% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R, R/generics.R,
%   R/ligerDataset-methods.R
\docType{class}
\name{ligerDataset-class}
\alias{ligerDataset-class}
\alias{ligerDataset}
\alias{rawData}
\alias{rawData<-}
\alias{normData}
\alias{normData<-}
\alias{scaleData}
\alias{scaleData<-}
\alias{scaleUnsharedData}
\alias{scaleUnsharedData<-}
\alias{getMatrix}
\alias{h5fileInfo}
\alias{h5fileInfo<-}
\alias{getH5File}
\alias{getH5File,ligerDataset,missing-method}
\alias{featureMeta}
\alias{featureMeta<-}
\alias{show,ligerDataset-method}
\alias{dim,ligerDataset-method}
\alias{dimnames,ligerDataset-method}
\alias{dimnames<-,ligerDataset,list-method}
\alias{rawData,ligerDataset-method}
\alias{rawData<-,ligerDataset,ANY,ANY,matrixLike_OR_NULL-method}
\alias{rawData<-,ligerDataset,ANY,ANY,H5D-method}
\alias{normData,ligerDataset-method}
\alias{normData<-,ligerDataset,ANY,ANY,matrixLike_OR_NULL-method}
\alias{normData<-,ligerDataset,ANY,ANY,H5D-method}
\alias{scaleData,ligerDataset,missing-method}
\alias{scaleData<-,ligerDataset,ANY,ANY,matrixLike_OR_NULL-method}
\alias{scaleData<-,ligerDataset,ANY,ANY,H5D-method}
\alias{scaleData<-,ligerDataset,ANY,ANY,H5Group-method}
\alias{scaleUnsharedData,ligerDataset,missing-method}
\alias{scaleUnsharedData<-,ligerDataset,missing,ANY,matrixLike_OR_NULL-method}
\alias{scaleUnsharedData<-,ligerDataset,missing,ANY,H5D-method}
\alias{scaleUnsharedData<-,ligerDataset,missing,ANY,H5Group-method}
\alias{getMatrix,ligerDataset,ANY,missing,missing-method}
\alias{h5fileInfo,ligerDataset-method}
\alias{h5fileInfo<-,ligerDataset-method}
\alias{featureMeta,ligerDataset-method}
\alias{featureMeta<-,ligerDataset-method}
\alias{cbind.ligerDataset}
\title{ligerDataset class}
\usage{
rawData(x, dataset = NULL)

rawData(x, dataset = NULL, check = TRUE) <- value

normData(x, dataset = NULL)

normData(x, dataset = NULL, check = TRUE) <- value

scaleData(x, dataset = NULL)

scaleData(x, dataset = NULL, check = TRUE) <- value

scaleUnsharedData(x, dataset = NULL)

scaleUnsharedData(x, dataset = NULL, check = TRUE) <- value

getMatrix(x, slot = "rawData", dataset = NULL, returnList = FALSE)

h5fileInfo(x, info = NULL)

h5fileInfo(x, info = NULL, check = TRUE) <- value

getH5File(x, dataset = NULL)

\S4method{getH5File}{ligerDataset,missing}(x, dataset = NULL)

featureMeta(x, check = NULL)

featureMeta(x, check = TRUE) <- value

\S4method{show}{ligerDataset}(object)

\S4method{dim}{ligerDataset}(x)

\S4method{dimnames}{ligerDataset}(x)

\S4method{dimnames}{ligerDataset,list}(x) <- value

\S4method{rawData}{ligerDataset}(x, dataset = NULL)

\S4method{rawData}{ligerDataset,ANY,ANY,matrixLike_OR_NULL}(x, dataset = NULL, check = TRUE) <- value

\S4method{rawData}{ligerDataset,ANY,ANY,H5D}(x, dataset = NULL, check = TRUE) <- value

\S4method{normData}{ligerDataset}(x, dataset = NULL)

\S4method{normData}{ligerDataset,ANY,ANY,matrixLike_OR_NULL}(x, dataset = NULL, check = TRUE) <- value

\S4method{normData}{ligerDataset,ANY,ANY,H5D}(x, dataset = NULL, check = TRUE) <- value

\S4method{scaleData}{ligerDataset,missing}(x, dataset = NULL)

\S4method{scaleData}{ligerDataset,ANY,ANY,matrixLike_OR_NULL}(x, dataset = NULL, check = TRUE) <- value

\S4method{scaleData}{ligerDataset,ANY,ANY,H5D}(x, dataset = NULL, check = TRUE) <- value

\S4method{scaleData}{ligerDataset,ANY,ANY,H5Group}(x, dataset = NULL, check = TRUE) <- value

\S4method{scaleUnsharedData}{ligerDataset,missing}(x, dataset = NULL)

\S4method{scaleUnsharedData}{ligerDataset,missing,ANY,matrixLike_OR_NULL}(x, check = TRUE) <- value

\S4method{scaleUnsharedData}{ligerDataset,missing,ANY,H5D}(x, check = TRUE) <- value

\S4method{scaleUnsharedData}{ligerDataset,missing,ANY,H5Group}(x, check = TRUE) <- value

\S4method{getMatrix}{ligerDataset,ANY,missing,missing}(
  x,
  slot = c("rawData", "normData", "scaleData", "scaleUnsharedData", "H", "V", "U", "A",
    "B"),
  dataset = NULL
)

\S4method{h5fileInfo}{ligerDataset}(x, info = NULL)

\S4method{h5fileInfo}{ligerDataset}(x, info = NULL, check = TRUE) <- value

\S4method{featureMeta}{ligerDataset}(x, check = NULL)

\S4method{featureMeta}{ligerDataset}(x, check = TRUE) <- value

\method{cbind}{ligerDataset}(x, ..., deparse.level = 1)
}
\arguments{
\item{x, object}{A \code{ligerDataset} object.}

\item{dataset}{Not applicable for \code{ligerDataset} methods.}

\item{check}{Whether to perform object validity check on setting new value.}

\item{value}{See detail sections for requirements}

\item{slot}{The slot name when using \code{getMatrix}.}

\item{returnList}{Not applicable for \code{ligerDataset} methods.}

\item{info}{Name of the entry in \code{h5fileInfo} slot.}

\item{...}{See detailed sections for explanation.}

\item{deparse.level}{Not used here.}
}
\description{
Object for storing dastaset specific information. Will be embedded within a
higher level \linkS4class{liger} object
}
\section{Slots}{

\describe{
\item{\code{rawData}}{Raw data.}

\item{\code{normData}}{Normalized data}

\item{\code{scaleData}}{Scaled data, usually with subset variable features}

\item{\code{scaleUnsharedData}}{Scaled data of features not shared with other
datasets}

\item{\code{varUnsharedFeatures}}{Variable features not shared with other datasets}

\item{\code{V}}{matrix}

\item{\code{A}}{matrix}

\item{\code{B}}{matrix}

\item{\code{H}}{matrix}

\item{\code{U}}{matrix}

\item{\code{h5fileInfo}}{list}

\item{\code{featureMeta}}{Feature metadata, DataFrame}

\item{\code{colnames}}{character}

\item{\code{rownames}}{character}
}}

\section{Matrix access}{

For \code{ligerDataset} object, \code{rawData()}, \code{normData},
\code{scaleData()} and \code{scaleUnsharedData()} methods are exported for
users to access the corresponding feature expression matrix. Replacement
methods are also available to modify the slots.

For other matrices, such as the \eqn{H} and \eqn{V}, which are dataset
specific, please use \code{getMatrix()} method with specifying slot name.
Directly accessing slot with \code{@} is generally not recommended.
}

\section{H5 file and information access}{

A \code{ligerDataset} object has a slot called \code{h5fileInfo}, which is a
list object. The first element is called \code{$H5File}, which is an
\code{H5File} class object and is the connection to the input file. The
second element is \code{$filename} which stores the absolute path of the H5
file in the current machine. The third element \code{$formatType} stores the
name of preset being used, if applicable. The other following keys pair with
paths in the H5 file that point to specific data for constructing a feature
expression matrix.

\code{h5fileInfo()} method access the list described above and simply
retrieves the corresponding value. When \code{info = NULL}, returns the whole
list. When \code{length(info) == 1}, returns the requested list value. When
more info requested, returns a subset list.

The replacement method modifies the list elements and corresponding slot
value (if applicable) at the same time. For example, running
\code{h5fileInfo(obj, "rawData") <- newPath} not only updates the list, but
also updates the \code{rawData} slot with the \code{H5D} class data at
"newPath" in the \code{H5File} object.

\code{getH5File()} is a wrapper and is equivalent to
\code{h5fileInfo(obj, "H5File")}.
}

\section{Feature metadata access}{

A slot \code{featureMeta} is included for each \code{ligerDataset} object.
This slot requires a \code{\link[S4Vectors]{DataFrame-class}} object, which
is the same as \code{cellMeta} slot of a \linkS4class{liger} object. However,
the associated S4 methods only include access to the whole table for now.
Internal information access follows the same way as data.frame operation.
For example, \code{featureMeta(ligerD)$nCell} or
\code{featureMeta(ligerD)[varFeatures(ligerObj), "gene_var"]}.
}

\section{Dimensionality}{

For a \code{ligerDataset} object, the column orientation is assigned for
cells and rows are for features. Therefore, for \code{ligerDataset} objects,
\code{dim()} returns a numeric vector of two numbers which are number of
features and number of cells. \code{dimnames()} returns a list of two
character vectors, which are the feature names and the cell barcodes.

For direct call of \code{dimnames<-} method, \code{value} should be a list
with a character vector of feature names as the first element and cell
identifiers as the second element. For \code{colnames<-} method, the
character vector of cell identifiers. For \code{rownames<-} method, the
character vector of feature names.
}

\section{Subsetting}{

For more detail of subsetting a \code{liger} object or a
\linkS4class{ligerDataset} object, please check out \code{\link{subsetLiger}}
and \code{\link{subsetLigerDataset}}. Here, we set the S3 method
"single-bracket" \code{[} as a quick wrapper to subset a \code{ligerDataset}
object. \code{i} and \code{j} serves as feature and cell subscriptor,
respectively, which can be any valid index refering the available features
and cells in a dataset. \code{...} arugments are passed to
\code{subsetLigerDataset} so that advanced options are allowed.
}

\section{Concatenate ligerDataset}{

\code{cbind()} method is implemented for concatenating \code{ligerDataset}
objects by cells. When applying, all feature expression matrix will be merged
with taking a union of all features for the rows.
}

\examples{
ctrl <- dataset(pbmc, "ctrl")

# Methods for base generics
ctrl
print(ctrl)
dim(ctrl)
ncol(ctrl)
nrow(ctrl)
colnames(ctrl)[1:5]
rownames(ctrl)[1:5]
ctrl[1:5, 1:5]

# rliger generics
## raw data
m <- rawData(ctrl)
class(m)
dim(m)
## normalized data
pbmc <- normalize(pbmc)
ctrl <- dataset(pbmc, "ctrl")
m <- normData(ctrl)
class(m)
dim(m)
## scaled data
pbmc <- selectGenes(pbmc)
pbmc <- scaleNotCenter(pbmc)
ctrl <- dataset(pbmc, "ctrl")
m <- scaleData(ctrl)
class(m)
dim(m)
n <- scaleData(pbmc, "ctrl")
identical(m, n)
## Any other matrices
if (requireNamespace("RcppPlanc", quietly = TRUE)) {
    pbmc <- runOnlineINMF(pbmc, k = 20, minibatchSize = 100)
    ctrl <- dataset(pbmc, "ctrl")
    V <- getMatrix(ctrl, "V")
    V[1:5, 1:5]
    Vs <- getMatrix(pbmc, "V")
    length(Vs)
    names(Vs)
    identical(Vs$ctrl, V)
}
}
