% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{createH5LigerDataset}
\alias{createH5LigerDataset}
\title{Create on-disk ligerDataset Object}
\usage{
createH5LigerDataset(
  h5file,
  formatType = "10x",
  rawData = NULL,
  normData = NULL,
  scaleData = NULL,
  barcodesName = NULL,
  genesName = NULL,
  indicesName = NULL,
  indptrName = NULL,
  anndataX = "X",
  modal = c("default", "rna", "atac", "spatial", "meth"),
  featureMeta = NULL,
  ...
)
}
\arguments{
\item{h5file}{Filename of an H5 file}

\item{formatType}{Select preset of H5 file structure. Default \code{"10X"}.
Alternatively, we also support \code{"anndata"} for H5AD files.}

\item{rawData, indicesName, indptrName}{The path in a H5 file for the raw
sparse matrix data. These three types of data stands for the \code{x},
\code{i}, and \code{p} slots of a \code{\link[Matrix]{dgCMatrix-class}}
object. Default \code{NULL} uses \code{formatType} preset.}

\item{normData}{The path in a H5 file for the "x" vector of the normalized
sparse matrix. Default \code{NULL}.}

\item{scaleData}{The path in a H5 file for the Group that contains the sparse
matrix constructing information for the scaled data. Default \code{NULL}.}

\item{genesName, barcodesName}{The path in a H5 file for the gene names and
cell barcodes. Default \code{NULL} uses \code{formatType} preset.}

\item{anndataX}{The HDF5 path to the raw count data in an H5AD file. See
Details. Default \code{"X"}.}

\item{modal}{Name of modality for this dataset. Currently options of
\code{"default"}, \code{"rna"}, \code{"atac"}, \code{"spatial"} and
\code{"meth"} are supported. Default \code{"default"}.}

\item{featureMeta}{Data frame for feature metadata. Default \code{NULL}.}

\item{...}{Additional slot data. See \linkS4class{ligerDataset} for detail.
Given values will be directly placed at corresponding slots.}
}
\value{
H5-based \linkS4class{ligerDataset} object
}
\description{
For convenience, the default \code{formatType = "10x"} directly fits the
structure of cellranger output. \code{formatType = "anndata"} works for
current AnnData H5AD file specification (see Details). If a customized H5
file structure is presented, any of the \code{rawData},
\code{indicesName}, \code{indptrName}, \code{genesName}, \code{barcodesName}
should be specified accordingly to override the \code{formatType} preset.

\bold{DO} make a copy of the H5AD files because rliger functions write to
the files and they will not be able to be read back to Python. This will be
fixed in the future.
}
\details{
For H5AD file written from an AnnData object, we allow using
\code{formatType = "anndata"} for the function to infer the proper structure.
However, while a typical AnnData-based analysis tends to in-place update the
\code{adata.X} attribute and there is no standard/forced convention for where
the raw count data, as needed from LIGER, is stored. Therefore, we expose
argument \code{anndataX} for specifying this information. The default value
\code{"X"} looks for \code{adata.X}. If the raw data is stored in a layer,
e.g. \code{adata.layers['count']}, then \code{anndataX = "layers/count"}.
If it is stored to \code{adata.raw.X}, then \code{anndataX = "raw/X"}. If
your AnnData object does not have the raw count retained, you will have to
go back to the Python work flow to have it inserted at desired object space
and re-write the H5AD file, or just go from upstream source files with which
the AnnData was originally created.
}
\examples{
h5Path <- system.file("extdata/ctrl.h5", package = "rliger")
tempPath <- tempfile(fileext = ".h5")
file.copy(from = h5Path, to = tempPath)
ld <- createH5LigerDataset(tempPath)
}
