% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5Utility.R
\name{restoreH5Liger}
\alias{restoreH5Liger}
\alias{restoreOnlineLiger}
\title{Restore links (to HDF5 files) for reloaded liger/ligerDataset object}
\usage{
restoreH5Liger(object, filePath = NULL)

restoreOnlineLiger(object, file.path = NULL)
}
\arguments{
\item{object}{\linkS4class{liger} or \linkS4class{ligerDataset} object.}

\item{filePath}{Paths to HDF5 files. A single character path for
\linkS4class{ligerDataset} input or a list of paths named by the datasets for
\linkS4class{liger} object input. Default \code{NULL} looks for the path(s)
of the last valid loading.}

\item{file.path}{Will be deprecated with \code{restoreOnlineLiger}. The same
as \code{filePath}.}
}
\value{
\code{object} with restored links.
}
\description{
When loading the saved liger object with HDF5 data in a new R
session, the links to HDF5 files would be closed. This function enables
the restoration of those links so that new analyses can be carried out.
}
\note{
\code{restoreOnlineLiger} will be deprecated for clarifying the terms used
for data structure.
}
\examples{
h5Path <- system.file("extdata/ctrl.h5", package = "rliger")
tempPath <- tempfile(fileext = ".h5")
file.copy(from = h5Path, to = tempPath)
lig <- createLiger(list(ctrl = tempPath))
# Now it is actually an invalid object! which is equivalent to what users
# will get with `saveRDS(lig, "object.rds"); lig <- readRDS("object.rds")``
closeAllH5(lig)
lig <- restoreH5Liger(lig)
}
