/*
 * Decompiled with CFR 0.152.
 */
package dmLab.array;

import dmLab.array.Array;
import dmLab.array.domain.ADXDomain;
import dmLab.array.domain.Domain;
import dmLab.array.domain.FDomain;
import dmLab.array.meta.Attribute;
import dmLab.array.meta.Dictionary;
import dmLab.array.meta.DiscRanges;
import dmLab.array.saver.Array2ADX;
import dmLab.utils.ArrayUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public final class FArray
extends Array {
    private float[][] valuesArray;
    private float[] decisionValues;
    private Domain[] domains;
    public Dictionary dictionary;
    public DiscRanges[] discRanges;

    public FArray() {
        this.dictionary = new Dictionary();
        this.domains = null;
        this.discRanges = null;
    }

    /*
     * WARNING - void declaration
     */
    public FArray(int columns, int rows) {
        void var2_2;
        void var1_1;
        this.init((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void init(int columns, int rows) {
        void var2_2;
        void var1_1;
        this.initAttributes$255f295(columns);
        this.dictionary = new Dictionary();
        this.valuesArray = new float[var1_1][var2_2];
        this.domains = null;
        this.discRanges = null;
    }

    @Override
    public final FArray clone() {
        return this.clone(null, null);
    }

    @Override
    public final FArray clone(boolean[] colMask, boolean[] rowMask) {
        FArray fArray = this;
        int srcColumns = fArray.attributes.length;
        fArray = this;
        int srcRows = fArray.valuesArray[0].length;
        if (colMask == null) {
            colMask = new boolean[srcColumns];
            Arrays.fill(colMask, true);
        }
        if (rowMask == null) {
            rowMask = new boolean[srcRows];
            Arrays.fill(rowMask, true);
        }
        int destColumns = ArrayUtils.count(colMask, true);
        int destRows = ArrayUtils.count(rowMask, true);
        FArray dstArray = null;
        if (srcColumns != colMask.length) {
            System.err.println("Incorrect length of colMask: " + colMask.length);
        } else if (srcRows != rowMask.length) {
            System.err.println("Incorrect length of rowMask: " + rowMask.length);
        } else {
            int currentColumn = 0;
            dstArray = new FArray(destColumns, destRows);
            if (this.discRanges != null) {
                dstArray.discRanges = new DiscRanges[destColumns];
            }
            if (this.domains != null) {
                dstArray.domains = new Domain[destColumns];
            }
            int i = 0;
            while (i < srcColumns) {
                if (colMask[i]) {
                    dstArray.attributes[currentColumn] = this.attributes[i].clone();
                    if (i == this.decAttrIdx) {
                        dstArray.decAttrIdx = currentColumn;
                        if (this.decisionValues != null) {
                            dstArray.decisionValues = (float[])this.decisionValues.clone();
                        }
                    }
                    if (this.discRanges != null && this.discRanges[i] != null) {
                        dstArray.discRanges[currentColumn] = this.discRanges[i].clone();
                    }
                    if (this.domains != null && this.domains[i] != null) {
                        dstArray.domains[currentColumn] = this.domains[i].clone();
                    }
                    ++currentColumn;
                }
                ++i;
            }
            dstArray.dictionary = this.dictionary.clone();
            int currentRow = 0;
            int j = 0;
            while (j < srcRows) {
                currentColumn = 0;
                if (rowMask[j]) {
                    int i2 = 0;
                    while (i2 < srcColumns) {
                        if (colMask[i2]) {
                            dstArray.valuesArray[currentColumn][currentRow] = this.valuesArray[i2][j];
                            ++currentColumn;
                        }
                        ++i2;
                    }
                    ++currentRow;
                }
                ++j;
            }
            if (dstArray.decAttrIdx == -1) {
                FArray fArray2 = dstArray;
                dstArray.decAttrIdx = fArray2.attributes.length - 1;
                dstArray.setAllDecValues();
            }
        }
        return dstArray;
    }

    @Override
    public final void cbind(Array array) {
        Object discRangesTMP;
        FArray fArray = this;
        if (fArray.valuesArray[0].length != array.rowsNumber()) {
            System.err.println("Function cbind cannot be used. Arrays have different numbers of rows.");
            return;
        }
        this.bindAttributes(array.attributes);
        FArray srcArray = (FArray)array;
        if (this.domainsCreated()) {
            this.domains = new FDomain[this.attributes.length];
        }
        if (this.discRanges != null) {
            discRangesTMP = this.discRanges;
            this.discRanges = new DiscRanges[this.attributes.length];
            int i = 0;
            while (i < this.discRanges.length) {
                this.discRanges[i] = i < ((DiscRanges[])discRangesTMP).length ? discRangesTMP[i] : srcArray.discRanges[0].clone();
                ++i;
            }
        }
        discRangesTMP = this;
        int rows = discRangesTMP.valuesArray[0].length;
        float[][] valuesArrayTMP = this.valuesArray;
        this.valuesArray = new float[this.attributes.length][rows];
        int j = 0;
        int i = 0;
        while (i < this.valuesArray.length) {
            if (i < valuesArrayTMP.length) {
                this.valuesArray[i] = valuesArrayTMP[i];
            } else if (srcArray.attributes[j].type == 2) {
                this.valuesArray[i] = (float[])srcArray.valuesArray[j++].clone();
            } else if (srcArray.attributes[j].type == 1) {
                int k = 0;
                while (k < rows) {
                    this.writeValueStr(i, k, srcArray.readValueStr(j, k));
                    ++k;
                }
                ++j;
            } else {
                System.err.println("Function cbind cannot copy the attribute. Type of attribute: " + srcArray.attributes[j].name + " is not NUMERICAL or NOMINAL.");
            }
            ++i;
        }
        if (this.domains != null) {
            this.findDomains();
        }
    }

    @Override
    public final int colsNumber() {
        return this.attributes.length;
    }

    @Override
    public final int rowsNumber() {
        return this.valuesArray[0].length;
    }

    public final boolean isDiscretized() {
        return this.discRanges != null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isDiscretized(int column) {
        void var1_1;
        return this.discRanges != null && this.discRanges[column] != null && this.discRanges[var1_1].getSize() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final float[] getColumn(int column) {
        void var1_1;
        return this.valuesArray[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String[] getColumnStr(int column) {
        void var1_1;
        void var2_3 = var1_1;
        FArray fArray = this;
        return this.dictionary.toString(fArray.valuesArray[var2_3]);
    }

    public final boolean setColumn(int column, float[] values) {
        block6: {
            block5: {
                FArray fArray = this;
                if (values.length != fArray.valuesArray[0].length) {
                    return false;
                }
                if (column < 0) break block5;
                fArray = this;
                if (column <= fArray.attributes.length) break block6;
            }
            return false;
        }
        int i = 0;
        while (i < values.length) {
            this.valuesArray[column][i] = values[i];
            ++i;
        }
        return true;
    }

    public final float[] getDecValues() {
        return this.decisionValues;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDecValues(float[] decValues) {
        if (decValues != null) {
            void var1_1;
            this.decisionValues = (float[])var1_1.clone();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String[] getDecValuesStr() {
        void var1_1;
        Object[] decValuesStr = null;
        if (this.attributes[this.decAttrIdx].type == 1) {
            decValuesStr = this.dictionary.toString(this.decisionValues);
        } else if (this.attributes[this.decAttrIdx].type == 2 && this.decisionValues != null) {
            decValuesStr = this.decisionValues;
            String[] stringArray = new String[this.decisionValues.length];
            int n = 0;
            while (n < decValuesStr.length) {
                stringArray[n] = Float.toString((float)decValuesStr[n]);
                ++n;
            }
            decValuesStr = stringArray;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean setDecValues(String[] decValues) {
        if (decValues != null) {
            this.decisionValues = new float[((String[])decValues).length];
            if (this.attributes[this.decAttrIdx].type == 1) {
                String[] stringArray = decValues;
                decValues = this.dictionary;
                float[] fArray = new float[stringArray.length];
                int n = 0;
                while (n < stringArray.length) {
                    fArray[n] = ((Dictionary)decValues).toFloat(stringArray[n]);
                    ++n;
                }
                this.decisionValues = fArray;
            } else if (this.attributes[this.decAttrIdx].type == 2) {
                void var1_1;
                this.decisionValues = ArrayUtils.string2float((String[])var1_1);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private float[] getUniqueValues$2558073() {
        Float[] floatArray;
        void var1_1;
        HashSet<Float> set = new HashSet<Float>();
        FArray fArray = this;
        int rows = fArray.valuesArray[0].length;
        int i = 0;
        while (i < rows) {
            set.add(Float.valueOf(this.readValue(this.decAttrIdx, i)));
            ++i;
        }
        Float[] floatValues = new Float[1];
        floatArray = (Float[])var1_1.toArray(floatArray);
        return ArrayUtils.float2Float(floatArray);
    }

    @Override
    public final boolean setAllDecValues() {
        this.decisionValues = (float[])(this.attributes[this.decAttrIdx].type == 1 ? this.getUniqueValues$2558073() : null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final float readValue(int column, int row) {
        void var2_2;
        void var1_1;
        return this.valuesArray[var1_1][var2_2];
    }

    /*
     * WARNING - void declaration
     */
    public final void writeValue(int column, int row, float value) {
        void var3_3;
        this.valuesArray[var1_1][var2_2] = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String readValueStr(int column, int row) {
        if (this.attributes[column].type == 1) {
            return this.dictionary.toString(this.valuesArray[column][row]);
        }
        if (this.attributes[column].type == 2) {
            void var2_2;
            void var1_1;
            String strValue = Dictionary.toStringSpecial(this.valuesArray[column][row]);
            if (strValue != null) {
                void var3_3;
                return var3_3;
            }
            return Float.toString(this.valuesArray[var1_1][var2_2]);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean writeValueStr(int column, int row, String value) {
        if (this.attributes[column].type == 1) {
            this.valuesArray[column][row] = this.dictionary.toFloat(value);
        } else if (this.attributes[column].type == 2) {
            Float floatValue = Dictionary.toFloatSpecial(value);
            if (floatValue == null) {
                try {
                    floatValue = Float.valueOf(Float.parseFloat(value));
                }
                catch (NumberFormatException numberFormatException) {
                    void var3_3;
                    System.err.println("Error parsing float value: " + (String)var3_3);
                    return false;
                }
            }
            this.valuesArray[var1_1][var2_2] = floatValue.floatValue();
        }
        return true;
    }

    public final boolean checkDecisionValues() {
        if (this.decAttrIdx == -1) {
            System.err.println("Decision Attribute is not Defined!");
            return false;
        }
        if (this.attributes[this.decAttrIdx].type != 1) {
            this.decisionValues = null;
            return true;
        }
        Float[] uniqueValues = ArrayUtils.float2Float(this.getUniqueValues$2558073());
        HashSet set = new HashSet();
        Collections.addAll(set, uniqueValues);
        int i = 0;
        while (i < this.decisionValues.length) {
            if (!set.contains(Float.valueOf(this.decisionValues[i]))) {
                System.err.println("Decision Value is not Present in the Dataset! Value: " + this.dictionary.toString(this.decisionValues[i]));
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final boolean findDomains() {
        this.domains = new FDomain[this.attributes.length];
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].type == 1) {
                this.domains[i] = new FDomain();
                int n = i;
                FArray fArray = this;
                ((FDomain)this.domains[i]).createDomain(fArray.valuesArray[n]);
            }
            ++i;
        }
        return true;
    }

    public final boolean findADXDomains() {
        this.domains = new ADXDomain[this.attributes.length];
        int i = 0;
        while (i < this.attributes.length) {
            FArray fArray;
            int n;
            this.domains[i] = new ADXDomain();
            if (this.isDiscretized(i)) {
                n = i;
                fArray = this;
                float[] fArray2 = fArray.valuesArray[n];
                n = this.decAttrIdx;
                fArray = this;
                ((ADXDomain)this.domains[i]).createDomain(this.discRanges[i].getRanges(), fArray2, fArray.valuesArray[n], this.decisionValues);
            } else {
                n = i;
                fArray = this;
                float[] fArray3 = fArray.valuesArray[n];
                n = this.decAttrIdx;
                fArray = this;
                ((ADXDomain)this.domains[i]).createDomain(null, fArray3, fArray.valuesArray[n], this.decisionValues);
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDomain(int column, Domain domain) {
        if (this.domains != null) {
            void var2_2;
            this.domains[var1_1] = var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final FDomain getFDomain(int column) {
        if (this.domains == null || this.domains[column] == null) {
            return null;
        }
        if (this.domains[column] instanceof FDomain) {
            void var1_1;
            return (FDomain)this.domains[var1_1];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final ADXDomain getADXDomain(int column) {
        if (this.domains == null || this.domains[column] == null) {
            return null;
        }
        if (this.domains[column] instanceof ADXDomain) {
            void var1_1;
            return (ADXDomain)this.domains[var1_1];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String[] getDomainStr(int column) {
        void var1_1;
        if (this.domains == null || this.domains[column] == null) {
            return null;
        }
        String[] stringArray = this.dictionary.toString(this.domains[var1_1].getDomainValues());
        return stringArray;
    }

    @Override
    public final boolean domainsCreated() {
        return this.domains != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void swapColumns(int source, int destination) {
        void var2_2;
        void var3_3;
        Attribute attributeTmp = this.attributes[source];
        this.attributes[source] = this.attributes[destination];
        this.attributes[destination] = attributeTmp;
        if (this.isDiscretized()) {
            DiscRanges discRangesTmp = this.discRanges[source];
            this.discRanges[source] = this.discRanges[destination];
            this.discRanges[destination] = discRangesTmp;
        }
        if (this.domainsCreated()) {
            Domain domainTmp = this.domains[source];
            this.domains[source] = this.domains[destination];
            this.domains[destination] = domainTmp;
        }
        float[] eventsArrayTmp = this.valuesArray[source];
        this.valuesArray[source] = this.valuesArray[destination];
        this.valuesArray[destination] = var3_3;
        if (this.decAttrIdx == source) {
            this.decAttrIdx = destination;
            return;
        }
        if (this.decAttrIdx == var2_2) {
            void var1_1;
            this.decAttrIdx = var1_1;
        }
    }

    public final String toString() {
        Array2ADX array2ADX = new Array2ADX();
        return array2ADX.toString(this);
    }

    public final String info() {
        FArray fArray = this;
        FArray fArray2 = fArray;
        fArray2 = this;
        return "attr: " + fArray.attributes.length + " events: " + fArray2.valuesArray[0].length;
    }
}

