/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.selector;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.utils.condition.Operator;
import java.util.Arrays;

public final class Selector
implements Cloneable {
    public int attrIndex;
    private boolean range;
    private Operator operator;
    private int size;
    private float[] values;
    public float posCoverage;
    public float negCoverage;
    public float posSupport;
    public float negSupport;
    public float coverage;
    private static int initSize = 2;

    public Selector() {
        this.range = false;
        this.attrIndex = -1;
        this.size = 0;
        this.values = new float[initSize];
        this.operator = new Operator();
    }

    /*
     * WARNING - void declaration
     */
    private Selector(boolean range, int size, int attrIndex, Operator operator, float[] values, float posCov, float negCov, float cov, float posSupport, float negSupport) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.values = values;
        this.size = var2_2;
        this.attrIndex = var3_3;
        this.operator = operator;
        this.posCoverage = posCov;
        this.negCoverage = negCov;
        this.posSupport = posSupport;
        this.negSupport = negSupport;
        this.coverage = cov;
        this.range = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Selector(boolean range, int attributeIndex, Operator operator, float value, float posCov, float negCov, float cov, float posSupport, float negSupport) {
        this(false, 1, (int)var2_2, (Operator)var3_3, new float[]{value}, posCov, negCov, cov, posSupport, negSupport);
        void var3_3;
        void var2_2;
    }

    public final Selector clone() {
        return new Selector(this.range, this.size, this.attrIndex, this.operator.clone(), this.values, this.posCoverage, this.negCoverage, this.coverage, this.posSupport, this.negSupport);
    }

    private int contains(float value) {
        int i = 0;
        while (i < this.size) {
            if (this.values[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean merge(Selector selector, FArray array) {
        float[] min_max2;
        void i2;
        if (this.attrIndex != selector.attrIndex) {
            return false;
        }
        if (this.operator.op != Operator.EQUAL) {
            return false;
        }
        if (!this.range && !array.isDiscretized(this.attrIndex)) {
            boolean merged22 = false;
            int i2 = 0;
            while (i2 < selector.size) {
                if (this.contains(selector.values[i2]) == -1) {
                    float f = selector.values[i2];
                    Selector merged22 = this;
                    if (merged22.size == merged22.values.length) {
                        Selector selector2 = merged22;
                        float[] fArray = new float[selector2.values.length + initSize];
                        System.arraycopy(selector2.values, 0, fArray, 0, selector2.size);
                        selector2.values = fArray;
                    }
                    merged22.values[merged22.size++] = f;
                    merged22 = true;
                }
                ++i2;
            }
            if (merged22) {
                this.posCoverage += selector.posCoverage;
                this.negCoverage += selector.negCoverage;
                this.posSupport += selector.posSupport;
                this.negSupport += selector.negSupport;
                this.coverage += selector.coverage;
            }
            return merged22;
        }
        float[] min_max1 = this.range ? this.values : i2.discRanges[this.attrIndex].getRange(this.values[0]);
        if (min_max1[1] >= (min_max2 = selector.range ? selector.values : min_max2.discRanges[this.attrIndex].getRange(selector.values[0]))[0] && min_max1[0] <= min_max2[1] || min_max2[1] >= min_max1[0] && min_max2[0] <= min_max1[1]) {
            void var1_1;
            void var2_2;
            void var3_6;
            this.values = new float[2];
            this.values[0] = Math.min(min_max1[0], min_max2[0]);
            this.values[1] = Math.max((float)var3_6[1], (float)var2_2[1]);
            this.size = this.values.length;
            this.range = true;
            this.posCoverage += selector.posCoverage;
            this.negCoverage += selector.negCoverage;
            this.posSupport += selector.posSupport;
            this.negSupport += selector.negSupport;
            this.coverage += var1_1.coverage;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean mergingPossible(Selector selector, FArray array) {
        void var1_1;
        if (this.attrIndex != selector.attrIndex) {
            return false;
        }
        if (this.operator.op != Operator.EQUAL || selector.operator.op != Operator.EQUAL) {
            return false;
        }
        if (!this.range && array.isDiscretized(this.attrIndex)) {
            void var3_3;
            void var2_2;
            float[] min_max2;
            float[] min_max1 = array.discRanges[this.attrIndex].getRange(this.values[0]);
            return min_max1[0] == (min_max2 = var2_2.discRanges[this.attrIndex].getRange(selector.values[0]))[1] || min_max1[1] == min_max2[0] || min_max1[1] >= min_max2[0] && min_max1[1] <= min_max2[1] || min_max2[1] >= min_max1[0] && var1_1[1] <= var3_3[1];
        }
        return !this.range || !(this.values[1] < var1_1.values[0]) && !(this.values[0] > var1_1.values[1]);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(Selector selector, FArray array) {
        void var1_1;
        if (this.attrIndex != selector.attrIndex) {
            return false;
        }
        if (this.operator.op != Operator.EQUAL || selector.operator.op != Operator.EQUAL) {
            return false;
        }
        if (!this.range && array.isDiscretized(this.attrIndex)) {
            float[] fArray;
            void var2_2;
            float[] min_max1 = array.discRanges[this.attrIndex].getRange(this.values[0]);
            float[] min_max2 = var2_2.discRanges[this.attrIndex].getRange(selector.values[0]);
            return fArray[0] >= min_max1[0] && var1_1[1] <= min_max1[1];
        }
        if (this.range && var1_1.values[0] >= this.values[0] && var1_1.values[1] <= this.values[1]) {
            return true;
        }
        if (!this.range) {
            int i = 0;
            while (i < var1_1.values.length) {
                if (this.contains(var1_1.values[i]) == -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return true;
    }

    public final float getValue(int index) {
        if (this.size > 0) {
            return this.values[0];
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean covers(float value) {
        if (Float.isNaN(value)) {
            return false;
        }
        if (!this.range && this.operator.op == Operator.EQUAL) {
            int i = 0;
            while (i < this.size) {
                if (this.values[i] == value) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (!this.range && this.operator.op == Operator.GREATER) {
            int i = 0;
            while (i < this.size) {
                if (this.values[i] > value) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (!this.range && this.operator.op == Operator.LESS) {
            int i = 0;
            while (i < this.size) {
                if (this.values[i] > value) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (!this.range && this.operator.op == Operator.GEQ) {
            int i = 0;
            while (i < this.size) {
                if (this.values[i] >= value) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (!this.range && this.operator.op == Operator.LEQ) {
            int i = 0;
            while (i < this.size) {
                if (this.values[i] <= value) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (this.range && this.operator.op == Operator.EQUAL) {
            void var1_1;
            if (this.values[0] == Float.NEGATIVE_INFINITY && this.values[1] == Float.POSITIVE_INFINITY) {
                return true;
            }
            if (value == Float.NEGATIVE_INFINITY && this.values[0] == Float.NEGATIVE_INFINITY) {
                return true;
            }
            return value > this.values[0] && var1_1 <= this.values[1];
        }
        System.err.println("Incorrect selector!");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(FArray array) {
        void var1_1;
        String string;
        StringBuffer tmp = new StringBuffer();
        String valuesStr = "";
        boolean rangesCreated = array.isDiscretized(this.attrIndex);
        short type = array.attributes[this.attrIndex].type;
        if (!this.range) {
            void var2_2;
            int i = 0;
            while (i < this.size) {
                if (type == 1) {
                    tmp.append(array.dictionary.toString(this.values[i]));
                } else if (type == 2 && rangesCreated) {
                    tmp.append(array.discRanges[this.attrIndex].getRangeStr(this.values[i]));
                } else if (type == 2 && !rangesCreated) {
                    tmp.append(this.values[i]);
                }
                if (i != this.size - 1) {
                    tmp.append(',');
                }
                ++i;
            }
            string = this.size > 1 ? "[" + tmp.toString() + "]" : var2_2.toString();
        } else if (this.range) {
            if (this.size == 2) {
                if (this.operator.op == Operator.EQUAL) {
                    string = "(" + this.values[0] + ";" + this.values[1] + "]";
                } else {
                    System.err.println("Incorrect selector! Selector contains '" + this.operator.toString() + "' and two values. Attribute: " + array.attributes[this.attrIndex].name);
                    string = Arrays.toString(this.values);
                }
            } else {
                System.err.println("Incorrect selector! Selector contains more than two values. Attribute: " + array.attributes[this.attrIndex].name);
                string = Arrays.toString(this.values);
            }
        }
        return String.valueOf(var1_1.attributes[this.attrIndex].name) + this.operator.toString() + string;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        String valuesStr;
        StringBuffer tmp = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            tmp.append(this.values[i]);
            if (i != this.size - 1) {
                tmp.append(',');
            }
            ++i;
        }
        valuesStr = this.size > 1 ? "[" + tmp.toString() + "]" : ((StringBuffer)((Object)valuesStr)).toString();
        return this.attrIndex + this.operator.toString() + (String)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final String toStringCov() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("p: " + DiscFunctions.formatFloat(this.posCoverage, 3));
        tmp.append(" n: " + DiscFunctions.formatFloat(this.negCoverage, 3));
        tmp.append(" c: " + DiscFunctions.formatFloat(this.coverage, 3));
        return var1_1.toString();
    }
}

