/*
 * Decompiled with CFR 0.152.
 */
package dmLab.experiment;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Params;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

public class ExperimentParams
extends Params
implements Cloneable {
    public static String DEFAULT_RES_PATH = ".//results//";
    public static String DEFAULT_DATA_PATH = ".//data//";
    private static String DEFAULT_CFG_PATH = ".//cfg//";
    public String label;
    public String inputFilesPATH;
    public String resFilesPATH;
    public String classifierCfgPATH;
    public String tmpPATH;
    public String inputFileName;
    public String[] inputFiles;
    public String testFileName;
    public String outputFileName;

    public ExperimentParams() {
        this.setDefault();
    }

    @Override
    public boolean setDefault() {
        this.verbose = false;
        this.fileType = "run";
        this.label = "experiment";
        this.inputFilesPATH = DEFAULT_DATA_PATH;
        this.resFilesPATH = DEFAULT_RES_PATH;
        this.classifierCfgPATH = DEFAULT_CFG_PATH;
        this.tmpPATH = String.valueOf(new File(DiscFunctions.getTmpDir("mcfs", 10)).getAbsolutePath()) + File.separator;
        this.inputFileName = "";
        this.testFileName = "";
        this.outputFileName = "";
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public ExperimentParams clone() {
        void var1_1;
        ExperimentParams p = new ExperimentParams();
        p.set(this);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(ExperimentParams p) {
        void var1_1;
        super.set(p);
        this.label = p.label;
        this.inputFilesPATH = p.inputFilesPATH;
        this.resFilesPATH = p.resFilesPATH;
        this.classifierCfgPATH = p.classifierCfgPATH;
        this.tmpPATH = p.tmpPATH;
        this.inputFileName = p.inputFileName;
        this.inputFiles = p.inputFiles;
        this.testFileName = p.testFileName;
        this.outputFileName = var1_1.outputFileName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("### Experiment Parameters ### \n");
        tmp.append(super.toString());
        tmp.append("label=" + this.label).append('\n');
        tmp.append("inputFilesPATH=" + this.inputFilesPATH).append('\n');
        tmp.append("resFilesPATH=" + this.resFilesPATH).append('\n');
        tmp.append("classifierCfgPATH=" + this.classifierCfgPATH).append('\n');
        tmp.append("tmpPATH=" + this.tmpPATH).append('\n');
        tmp.append("inputFileName=" + this.inputFileName).append('\n');
        if (this.inputFiles != null) {
            tmp.append("inputFiles=" + Arrays.toString(this.inputFiles)).append('\n');
        } else {
            tmp.append("inputFiles=" + this.inputFileName).append('\n');
        }
        if (this.testFileName != null) {
            tmp.append("testFileName=" + this.testFileName).append('\n');
        }
        if (this.outputFileName != null) {
            tmp.append("outputFileName=" + this.outputFileName).append('\n');
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean update(Properties properties) {
        void var1_1;
        this.verbose = Boolean.valueOf(properties.getProperty("verbose", "false"));
        this.label = properties.getProperty("label", "experiment");
        this.inputFilesPATH = properties.getProperty("inputFilesPATH", DEFAULT_DATA_PATH);
        this.resFilesPATH = properties.getProperty("resFilesPATH", DEFAULT_RES_PATH);
        this.classifierCfgPATH = properties.getProperty("classifierCfgPATH", DEFAULT_CFG_PATH);
        this.inputFileName = properties.getProperty("inputFileName", "inputFile.adx");
        this.inputFiles = DiscFunctions.tokenizeArray(this.inputFileName);
        if (this.inputFiles == null) {
            System.err.println("Parameter 'inputFileName' is not defined");
            return false;
        }
        if (this.inputFiles.length > 1) {
            this.inputFileName = this.inputFiles[0];
        }
        this.testFileName = properties.getProperty("testFileName", null);
        this.outputFileName = var1_1.getProperty("outputFileName", null);
        return true;
    }

    @Override
    public boolean check(FArray array) {
        return true;
    }

    public final String getExperimentName() {
        return this.inputFileName.substring(0, this.inputFileName.lastIndexOf(46));
    }

    /*
     * WARNING - void declaration
     */
    public static String getExperimentName(String fileName) {
        void var2_2;
        int experimentPrefixIndex = fileName.lastIndexOf("__");
        if (experimentPrefixIndex == -1) {
            experimentPrefixIndex = fileName.lastIndexOf("_");
        }
        String experimentPrefix = "";
        if (experimentPrefixIndex != -1) {
            void var1_1;
            String string;
            experimentPrefix = string.substring(0, (int)(var1_1 + true));
        }
        return var2_2;
    }
}

