/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Instance;
import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.neighboursearch.PerformanceStats;

public abstract class AbstractStringDistanceFunction
extends NormalizableDistance {
    public AbstractStringDistanceFunction() {
    }

    public AbstractStringDistanceFunction(Instances data) {
        super(data);
    }

    @Override
    protected double updateDistance(double currDist, double diff) {
        return currDist + diff * diff;
    }

    protected double difference(int index, String string1, String string2) {
        switch (this.m_Data.attribute(index).type()) {
            case 2: {
                double diff = this.stringDistance(string1, string2);
                if (this.m_DontNormalize) {
                    return diff;
                }
                if (string1.length() > string2.length()) {
                    return diff / (double)string1.length();
                }
                return diff / (double)string2.length();
            }
        }
        return 0.0;
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        double sqDistance = 0.0;
        int numAttributes = this.m_Data.numAttributes();
        this.validate();
        int i = 0;
        while (i < numAttributes) {
            double diff = 0.0;
            if (this.m_ActiveIndices[i]) {
                diff = this.difference(i, first.stringValue(i), second.stringValue(i));
            }
            if ((sqDistance = this.updateDistance(sqDistance, diff)) > cutOffValue * cutOffValue) {
                return Double.POSITIVE_INFINITY;
            }
            ++i;
        }
        double distance = Math.sqrt(sqDistance);
        return distance;
    }

    abstract double stringDistance(String var1, String var2);
}

